<?php

namespace App\Http\Controllers\Requests;

use App\Http\Controllers\Controller;
use App\Model\BusinessClient;
use App\Model\Request as ModelRequest;
use App\Model\RequestDeposit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class RequestDepositController extends Controller
{
    
    /**
     * Adds a deposit to request model
     */
    public function addDeposit(Request $request) {
        $record = RequestController::storeRequest($request);
        $partnership = $record->businessClient->partnership;
        
        $internalClients = BusinessClient::where('type', 'I')
            ->whereNull('canceled_at')->get();
        
        $deposits = $record->deposits;
        $invoices = [];
        foreach ($record->invoices as $invoice) {
            array_push($invoices, $invoice);
        }
        return view('client.new-request', [
            'record' => $record,
            'partnership' => $partnership,
            'internalClients' => $internalClients,
            'newDeposit' => 1,
            'deposits' => $deposits
        ]);
    }

    /**
     * Removes a deposit from request model
     */
    public function removeDeposit(Request $request, $id) {
        $record = RequestController::storeRequest($request);
        if ($id != 'new') {
            Storage::disk('s3')->delete($record->voucher_file);
            $deposit = RequestDeposit::find($id);
            $deposit->invoices()->delete();
            $deposit->delete();
        } else {
            $request->merge(['new-deposit' => 0]);
        }
        return redirect('/client/requests/' . $record->id . '/edit?new-deposit=' 
            . $request->input('new-deposit'));
    }

}
