<?php

namespace App\Http\Controllers\Requests;

use App\Http\Controllers\Controller;
use App\Model\BusinessClient;
use App\Model\Request as ModelRequest;
use App\Model\RequestDeposit;
use App\Model\RequestInvoice;
use App\Model\RequestInvoiceConcept;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\View\View;

class InvoiceController extends Controller
{

    /**
     * Shows a form for edit a invoices
     */
    public function showInvoice(Request $request, $id) {
        $deposit = RequestDeposit::find($id);
        $record = $deposit->request;
        $partnership = $record->businessClient->partnership;
        
        $internalClients = BusinessClient::where('type', 'I')
            ->whereNull('canceled_at')->get();
        
        $deposits = $record->deposits;
        /*
        $invoices = [];
        foreach ($record->invoices as $invoice) {
            array_push($invoices, $invoice);
        }*/
        $invoice = $deposit->invoice;
        if (!$invoice) {
            $invoice = new RequestInvoice();
            $invoice->receiver()->associate($deposit->origin);
            $invoice->emissor()->associate($deposit->destination);
        } 
        $currentConcept = new RequestInvoiceConcept();
        return view('client.new-request', [
            'record' => $record,
            'partnership' => $partnership,
            'internalClients' => $internalClients,
            'newDeposit' => $request->has('new-deposit') ? $request->input('new-deposit') : 0,
            'deposits' => $deposits,
            'currentDeposit' => $deposit,
            'currentInvoice' => $invoice,
            'currentConcept' => $currentConcept
        ]);
    }

    /**
     * Store a invoice
     */
    public function storeInvoiceFromDeposit(Request $request, $id) {
        $deposit = RequestDeposit::find($id);
        $record = $deposit->request;
        
        if ($request->input('concept-amount') > 0) {
            $invoice = $deposit->invoice;
            if (!$invoice) {
                $invoice = new RequestInvoice();
                $invoice->request()->associate($record);
                $invoice->receiver()->associate($deposit->origin);
                $invoice->emissor()->associate($deposit->destination);
                $invoice->deposit()->associate($deposit);
                $invoice->amount = 100;
            }
            $invoice->save();

            $concept = new RequestInvoiceConcept();
            $concept->requestInvoice()->associate($invoice);
            $concept->partnership_concept_id = $request->input('concept-concept');
            $concept->description = $request->input('concept-description');
            if (!$concept->description) {
                $concept->description = '';
            }
            $concept->amount = $request->input('concept-amount');
            if ($concept->amount > 0) {
                $concept->save();
                $request->merge(['new-concept' => 0]);
            }

            $invoice->amount = $concept->amount;
            $invoice->save();
        }    
        $deposit->refresh();
        $deposit->calcInvoices();
        return redirect("/client/requests/$record->id/edit");
    }
    
    public function destroyInvoiceFromDeposit(Request $request, $id, $conceptId) {        
        $concept = RequestInvoiceConcept::find($conceptId);
        $requestInvoice = $concept->requestInvoice;
        $deposit = RequestDeposit::find($requestInvoice->request_deposit_id);
        $concept->delete();        

        $deposit->calcInvoices();
        return redirect("/client/requests/$id/edit");
    }

    /**
     * Shows a form for edit a invoices
     */
    public function show(Request $request, $id) {
        $record = ModelRequest::find($id);
        $partnership = $record->businessClient->partnership;
        
        $internalClients = BusinessClient::where('type', 'I')
            ->whereNull('canceled_at')->get();

        $currentInvoice = new RequestInvoice();
        $invoices = [];
        if (count($record->requestInvoices) == 0) {
            array_push($invoices, $currentInvoice);
        }
        foreach ($record->requestInvoices as $invoice) {
            array_push($invoices, $invoice);
            $currentInvoice = $invoice;
        }
        return view('client.components.invoices', [
            'record' => $record,
            'partnership' => $partnership,
            'internalClients' => $internalClients,
            'editInvoice' => $currentInvoice->id,
            'invoices' => $invoices,
            'newConcept' => $currentInvoice == null || count($currentInvoice->concepts) == 0 ? 1 : 0
        ]);
    }

    /**
     * shows a form for edit a invoice
     * @param Request $request 
     * @param mixed $id 
     * @param mixed $invoiceId 
     * @return View|Factory 
     */
    public function edit(Request $request, $id, $invoiceId) {
        $currentInvoice = RequestInvoice::find($invoiceId);
        $record = $currentInvoice->request;
        $partnership = $record->businessClient->partnership;
        
        $internalClients = BusinessClient::where('type', 'I')
            ->whereNull('canceled_at')->get();
        $invoices = [];
        foreach ($record->requestInvoices as $invoice) {
            array_push($invoices, $invoice);
        }
        return view('client.components.invoices', [
            'record' => $record,
            'partnership' => $partnership,
            'internalClients' => $internalClients,
            'editInvoice' => $currentInvoice->id,
            'invoices' => $invoices,
            'newConcept' => $currentInvoice == null || count($currentInvoice->concepts) == 0 ? 1 : 0
        ]);
    }

    /**
     * Adds a invoice to request model
     */
    public function create(Request $request, $id) {        
        $record = InvoiceController::storeInvoice($request, $id)->request;
        $partnership = $record->businessClient->partnership;
        
        foreach ($record->requestInvoices as $invoice) {
            if ($invoice->amount == 0) {
                return redirect('/client/requests/' . $invoice->id . '/edit-invoice');
            }
        }
        $internalClients = BusinessClient::where('type', 'I')
            ->whereNull('canceled_at')->get();
        
        $invoices = [];
        foreach ($record->requestInvoices as $invoice) {
            array_push($invoices, $invoice);
        }
        $invoice = new RequestInvoice();
        array_push($invoices, $invoice);

        return view('client.components.invoices', [
            'record' => $record,
            'partnership' => $partnership,
            'internalClients' => $internalClients,
            'editInvoice' => 0,
            'invoices' => $invoices,
            'newConcept' => 1
        ]);
    }

    /**
     * Store a invoice
     */
    public function store(Request $request, $id) {
        $currentInvoice = InvoiceController::storeInvoice($request, $id);

        $record = ModelRequest::find($id);
        $partnership = $record->businessClient->partnership;
        
        $internalClients = BusinessClient::where('type', 'I')
            ->whereNull('canceled_at')->get();

        $invoices = [];
        foreach ($record->requestInvoices as $invoice) {
            array_push($invoices, $invoice);
        }
        return view('client.components.invoices', [
            'record' => $record,
            'partnership' => $partnership,
            'internalClients' => $internalClients,
            'editInvoice' => $currentInvoice->id,
            'invoices' => $invoices,
            'newConcept' => 0
        ]);
    }

    /**
     * Destroys a invoice
     */
    public function destroy(Request $request, $id, $invoiceId) {
        InvoiceController::storeInvoice($request, $id);
        $record = ModelRequest::find($id);
        if ($invoiceId != 'new') {
            if (count($record->requestInvoices) > 1) {
                $invoice = RequestInvoice::find($invoiceId);
                $invoice->delete();
            }
        }
        $editInvoice = $request->input('edit-invoice');
        if ($invoiceId != $editInvoice) {
            return redirect('/client/requests/' . $invoice->request_id . '/invoices/' . $editInvoice . '/edit');    
        }
        $record->refresh();
        foreach ($record->requestInvoices as $invoice) {
            $editInvoice = $invoice->id;
            break;
        }
        return redirect('/client/requests/' . $invoice->request_id . '/invoices/' . $editInvoice . '/edit');
    }

    /**
     * Stores current invoice
     */
    public static function storeInvoice(Request $request, $id) {
        $record = ModelRequest::find($id);

        $invoice = new RequestInvoice();
        $invoice->request()->associate($record);
        if ($request->input('invoice-id')) {
            $invoice = RequestInvoice::find($request->input('invoice-id'));
        }
        $invoice->emissor_id = $request->input('invoice-emissor');
        $invoice->receiver_id = $request->input('invoice-receiver');
        $invoice->amount = $request->input('invoice-amount');
        if (!$invoice->amount) {
            $invoice->amount = 0;
        }
        $invoice->save();
        if ($request->has('new-concept') && $request->input('new-concept') == 1) {
            $concept = new RequestInvoiceConcept();
            $concept->requestInvoice()->associate($invoice);
            $concept->partnership_concept_id = $request->input('concept-concept');
            $concept->description = $request->input('concept-description');
            if (!$concept->description) {
                $concept->description = '';
            }
            $concept->amount = $request->input('concept-amount');
            if ($concept->amount > 0) {
                $concept->save();
                $request->merge(['new-concept' => 0]);
            }
        }
        $amount = 0;
        foreach ($invoice->concepts as $concept) {
            $amount += $concept->amount;
        }
        $invoice->amount = $amount;
        $invoice->save();
        return $invoice;
    }
}
