<?php

namespace App\Http\Controllers\Requests;

use App\Http\Controllers\Controller;
use App\Model\BusinessClient;
use App\Model\RequestInvoice;
use App\Model\RequestInvoiceConcept;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class InvoiceConceptController extends Controller
{

    /**
     * Adds a invoice to request model
     */
    public function create(Request $request, $id, $invoiceId) {    
        $record = InvoiceController::storeInvoice($request, $id)->request;

        $currentInvoice = RequestInvoice::find($invoiceId);
        $partnership = $record->businessClient->partnership;
        
        $internalClients = BusinessClient::where('type', 'I')
            ->whereNull('canceled_at')->get();
        $invoices = [];
        foreach ($record->invoices as $invoice) {
            array_push($invoices, $invoice);
        }
        return view('client.components.invoices', [
            'record' => $record,
            'partnership' => $partnership,
            'internalClients' => $internalClients,
            'editInvoice' => $currentInvoice->id,
            'invoices' => $invoices,
            'newConcept' => 1
        ]);
    }

    /**
     * Removes a deposit from request model
     */
    public function destroy(Request $request, $id, $invoiceId, $conceptId) {
        InvoiceController::storeInvoice($request, $id);
        if ($conceptId != 'new') {
            $concept = RequestInvoiceConcept::find($conceptId);
            $concept->delete();
        }
        
        $invoice = RequestInvoice::find($invoiceId);
        $amount = 0;
        foreach ($invoice->concepts as $concept) {
            $amount += $concept->amount;
        }
        $invoice->amount = $amount;
        $invoice->save();
        return redirect('/client/requests/' . $id . '/invoices/' . $invoiceId . '/edit');
    }
    
}
