<?php

namespace App\Http\Controllers\Partnership;

use App\Http\Controllers\Controller;
use App\Model\Partnership;
use App\Model\PartnershipContact;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class PartnershipContactController extends Controller
{

    /**
     * Creates a business contact for create a new department
     */
    public function create(Request $request, $id) {
        $contact = new PartnershipContact();
        $partnership = Partnership::find($id);

        return view('admin.partnership-contact', [
            'partnership' => $partnership,
            'contact' => $contact
        ]);
    }

    /**
     * Creates a business department for create a new department
     */
    public function edit(Request $request, $id) {
        $contact = PartnershipContact::find($id);

        return view('admin.partnership-contact', [
            'partnership' => $contact->partnership,
            'contact' => $contact
        ]);
    }

    /**
     * Save a partnership contact
     */
    public function store(Request $request) {
        $contact = new PartnershipContact();
        if ($request['contact-id'] != null) {
            $contact = PartnershipContact::find($request['contact-id']);
        }
        $contact->name = $request['name'];
        $contact->second_name = $request['second-name'];
        $contact->second_last_name = $request['second-last-name'];
        $contact->email = $request['email'];
        $contact->comments = $request['comments'];
        $contact->partnership_id = $request['partnership-id'];
        $contact->save();

        Cache::put('message', 'Se salvo correctamente al contacto ' . 
            $contact->name);
        return redirect('/admin/partnership-contacts/' . $contact->id . '/edit');
    }

    /**
     * Deletes a partnership contact
     */
    public function destroy(Request $request) {
        $contact = new PartnershipContact();
        if ($request['contact-id'] != null) {
            $contact = PartnershipContact::find($request['contact-id']);
            $contact->delete();
            Cache::put('message', 'Se elimino al contacto ' . $contact->name);
        }
        return redirect('/admin/partnerships/' . $request['partnership-id'] . '/edit');
    }
}
