<?php

namespace App\Http\Controllers\Partnership;

use Illuminate\Http\Request;
use App\Model\BusinessClient;
use App\Http\Controllers\Controller;
use App\Model\Partnership;
use App\Model\PartnershipConcepts;
use App\Model\PartnershipContact;
use Illuminate\Contracts\View\Factory;
use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;

class PartnershipConceptController extends Controller
{
    
    /**
     * Shows a form for create a partnership concept
     * @param Request $request Request data
     * @param mixed $id Partnership id
     * @param mixed $clientId Business client id
     * @return View|Factory 
     */
    public function create(Request $request, $id, $clientId) {
        $partnership = Partnership::find($id);
        $business = BusinessClient::find($clientId);
        $concept = new PartnershipConcepts();
        $concept->partnerhip_id = $id;
        $concept->business_client_id = $clientId;

        return view('admin.components.partnership-concept', [
            'partnership' => $partnership,
            'business' => $business,
            'concept' => $concept
        ]);
    }

    /**
     * shows a form for edit a partnership concept
     * 
     * @param id The id of the concept
     */
    public function edit(Request $request, $id) {
        $concept = PartnershipConcepts::find($id);
        return view('admin.components.partnership-concept', [
            'partnership' => $concept->partnership,
            'business' => $concept->businessClient,
            'concept' => $concept
        ]);
    }

    /**
     * Store a business concept
     * 
     * @param request with the data of the concept
     */
    public function store(Request $request) {
        $partnership = Partnership::find($request['partnership-id']);
        $concept = new PartnershipConcepts();
        if ($request['id'] != null) {
            $concept = PartnershipConcepts::find($request['id']);
        }
        $concept->code = $request['code'];
        $concept->description = $request['description'];
        $concept->partnership_id = $request['partnership-id'];
        $concept->business_client_id = $request['business-id'];
        $concept->status = $partnership->IsActive($request['business-id']) ? '1' : '0';
        $concept->save();

        Cache::put('message', 'Se salvo correctamente el concepto ' 
            . $concept->name);
        return redirect('/admin/partnerships/' . $concept->partnership_id 
            . '/edit/' . $concept->businessClient->code);
    }

    /**
     * Deletes a partnership concept
     */
    public function destroy(Request $request, $id) {
        $concept = PartnershipConcepts::find($id);
        $concept->delete();

        Cache::put('message', 'Se elimino el concepto ' . $concept->name);
        return redirect('/admin/partnerships/' . $concept->partnership_id 
            . '/edit/' . $concept->businessClient->code);
    }

    public function active(Request $request, $id, $clientId) {
        PartnershipConcepts::where('partnership_id', $id)
            ->where('business_client_id', $clientId)
            ->update(['status' => '1']);
            
        $client = BusinessClient::find($clientId);
        return redirect('/admin/partnerships/' . $id . '/edit/' . $client->code);
    }

    public function desactive(Request $request, $id, $clientId) {
        PartnershipConcepts::where('partnership_id', $id)
            ->where('business_client_id', $clientId)
            ->update(['status' => '0']);
        
        $client = BusinessClient::find($clientId);
        return redirect('/admin/partnerships/' . $id . '/edit/' . $client->code);
    }
}
