<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Imports\MapperCellImport;
use App\Http\Controllers\Imports\MapperImport;
use App\Http\Controllers\Imports\MapperSheetImport;
use DateTime;
use Exception;
use Faker\Provider\DateTime as FakerDateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;

class MapperController extends Controller
{
    
    /**
     * Map excel information into response data
     */
    function mapExcel(Request $request) {
        if (!$request->has('excel')) {
            return response()->json([
                'status' => 'warning',
                'message' => 'Please provide [excel] to transform'
            ]);
        }
        if (!$request->has('map')) {
            return response()->json([
                'status' => 'warning',
                'message' => 'Please provide [map] to transform'
            ]);
        }

        $now = new \DateTime();
        $xls = $now->getTimestamp() . '.xlsx';
        try {
            Storage::disk('local')->put($xls, base64_decode($request->json('excel')));
            
            $sheetImporter = new MapperSheetImport();
            $sheet = 0;
            if ($request->has('sheet')) {
                $sheet = $request->json('sheet');
            }
            $sheetImporter->setSheet($sheet, $request->json('map'));
            
            Excel::import($sheetImporter, $xls, 'local');
            Storage::disk('local')->delete($xls);
            return response()->json([
                'status' => 'ok',
                'data' => $sheetImporter->getResponse()
            ]);
        } catch(Exception $ex) {
            report($ex);
            return response()->json([
                'status' => 'error',
                'message' => $ex->getMessage()
            ]);
        }
    }

    public function readExcel($content, $map) {
        $now = new \DateTime();
        $xls = $now->getTimestamp() . '.xlsx';
        try {
            Storage::disk('local')->put($xls, base64_decode($content));
            
            $sheetImporter = new MapperSheetImport();
            $sheet = 0;
            $sheetImporter->setSheet($sheet, $map);
            
            Excel::import($sheetImporter, $xls, 'local');
            Storage::disk('local')->delete($xls);
            return $sheetImporter->getResponse();
        } catch(Exception $ex) {
            report($ex);
            Storage::disk('local')->delete($xls);
            return response()->json([
                'status' => 'error',
                'message' => $ex->getMessage()
            ]);
        }
    }

    /**
     * Transforms response to employees
     */
    public function getSalariedEmployees($response) {
        $employees = [];
        foreach ($response as $emp) {
            if ($emp['name'] && $emp['rfc'] && $emp['curp'] && $emp['salaryDay'] 
                && $emp['factory'] && $emp['days']) {
                array_push($employees, $emp);
            }
        }
        if (count($employees) > 0) {
            unset($employees[0]);
        }
        return $employees;
    }

    /**
     * Transforms response to employees
     */
    public function getEmployees($response) {
        $employees = [];
        foreach ($response as $emp) {
            //if ($emp['employeeNum'] && $emp['name'] && $emp['partnership']) {
                array_push($employees, $emp);
            //}
        }
        if (count($employees) > 0) {
            unset($employees[0]);
        }
        return $employees;
    }

    /**
     * Transforms response to employees
     */
    public function getAccountEmployees($response) {
        $employees = [];
        foreach ($response as $emp) {
            if ($emp['account'] && $emp['bank'] && $emp['partnership']) {
                array_push($employees, $emp);
            }
        }
        if (count($employees) > 0) {
            unset($employees[0]);
        }
        return $employees;
    }

    /**
     * Transforms response to employees
     */
    public function getAssimilatedEmployees($response) {
        $employees = [];
        foreach ($response as $emp) {
            if ($emp['partnership'] && $emp['name'] && $emp['curp'] 
                && $emp['rfc'] && $emp['total']) {
                $emp['partnership'] = trim($emp['partnership']);
                $emp['name'] = trim($emp['name']);
                $emp['firstName'] = trim($emp['firstName']);
                $emp['lastName'] = trim($emp['lastName']);
                $emp['curp'] = trim($emp['curp']);
                $emp['rfc'] = trim($emp['rfc']);
                array_push($employees, $emp);
            }
        }
        if (count($employees) > 0) {
            unset($employees[0]);
        }
        return $employees;
    }

    /**
     * Transform response to subside table
     */
    public function getSubsideTable($response) {
        $subsides = [];
        foreach ($response as $subside) {
            if ($subside['lowerLimit'] && $subside['fixedFee'] 
                && $subside['total']) {
                array_push($subsides, $subside);
            }
        }
        if (count($subsides) > 0) {
            unset($subsides[0]);
        }
        return $this->getSubsideArray($subsides);
    }

    /**
     * Parse map to array
     */
    private function getSubsideArray($subsides) {
        $lowerLimits = [];
        $upperLimits = [];
        $fixedFees = [];
        $percents = [];
        $incomes = [];
        $subs = [];

        foreach($subsides as $subside) {
            array_push($lowerLimits, $subside['lowerLimit']);
            array_push($upperLimits, $subside['upperLimit']);
            array_push($fixedFees, $subside['fixedFee']);
            array_push($percents, $subside['percent']);

            if (isset($subside['income'])) {
                array_push($incomes, $subside['income']);
            }
            if (isset($subside['subside'])) {
                array_push($subs, $subside['subside']);
            }
        }
        return [
            'lowerLimits' => $lowerLimits,
            'upperLimits' => $upperLimits,
            'fixedFees' => $fixedFees,
            'percents' => $percents,
            'incomes' => $incomes,
            'subsides' => $subs
        ];
    }

}
