<?php

namespace App\Http\Controllers\InternalClient;

use App\Http\Controllers\Controller;
use App\Model\BusinessClient;
use App\Model\BusinessClientConcept;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class BusinessClientConceptController extends Controller
{
    
    /**
     * shows a form for create a new business concept
     */
    public function create(Request $request, $id) {
        $business = BusinessClient::find($id);
        $concept = new BusinessClientConcept();

        return view('admin.business-concept', [
            'business' => $business,
            'concept' => $concept
        ]);
    }

    /**
     * shows a form for edit a business concept
     * 
     * @param id The id of the concept
     */
    public function edit(Request $request, $id) {
        $concept = BusinessClientConcept::find($id);

        return view('admin.business-concept', [
            'business' => $concept->businessClient,
            'concept' => $concept
        ]);
    }

    /**
     * Store a business concept
     * 
     * @param request with the data of the concept
     */
    public function store(Request $request) {
        $concept = new BusinessClientConcept();
        if ($request['conceptId'] != null) {
            $concept = BusinessClientConcept::find($request['conceptId']);
        }
        $concept->code = $request['code'];
        $concept->name = $request['name'];
        $concept->type = $request['type'];
        $concept->business_client_id = $request['id'];
        $concept->save();

        Cache::put('message', 'Se salvo correctamente el concepto ' .
            $concept->name);
        return redirect('/admin/business-concepts/' . $concept->id . '/edit');
    }

    /**
     * Deletes a business concept
     */
    public function destroy(Request $request) {
        $concept = new BusinessClientConcept();
        if ($request['conceptId'] != null) {
            $concept = BusinessClientConcept::find($request['conceptId']);
        }
        $concept->delete();

        Cache::put('message', 'Se elimino el concepto ' . $concept->name);
        return redirect('/admin/internal-business-clients/' . $request['id'] . '/edit');
    }

}
