<?php

namespace App\Http\Controllers\InternalClient;

use App\Http\Controllers\Controller;
use App\Model\BusinessBranch;
use App\Model\BusinessClient;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class BusinessClientBranchController extends Controller
{
    
    /**
     * shows a form for create a new business branch
     */
    public function create(Request $request, $id) {
        $business = BusinessClient::find($id);
        $branch = new BusinessBranch();

        return view('admin.business-branch', [
            'business' => $business,
            'branch' => $branch
        ]);
    }

    /**
     * shows a form for edit a business branch
     * 
     * @param id The id of the branch
     */
    public function edit(Request $request, $id) {
        $branch = BusinessBranch::find($id);

        return view('admin.business-branch', [
            'business' => $branch->businessClient,
            'branch' => $branch
        ]);
    }

    /**
     * Store a business branch
     * 
     * @param request with the data of the branch
     */
    public function store(Request $request) {
        $branch = new BusinessBranch();
        if ($request['branchId'] != null) {
            $branch = BusinessBranch::find($request['branchId']);
        }
        $branch->name = $request['name'];
        $branch->prefix = $request['prefix'];
        $branch->postal_code = $request['postal-code'];
        $branch->business_client_id = $request['id'];
        $branch->save();

        Cache::put('message', 'Se salvo correctamente el lugar de expedición' .
            $branch->name);
        return redirect('/admin/business-branches/' . $branch->id . '/edit');
    }

    /**
     * Deletes a business branch
     */
    public function destroy(Request $request) {
        $department = new BusinessBranch();
        if ($request['branchId'] != null) {
            $department = BusinessBranch::find($request['branchId']);
        }
        $department->delete();

        Cache::put('message', 'Se elimino el lugar de expedición ' .
            $department->name);
        return redirect('/admin/internal-business-clients/' . $request['id'] . '/edit');
    }

}
