<?php

namespace App\Http\Controllers\InternalClient;

use App\Http\Controllers\Controller;
use App\Model\BusinessClient;
use App\Model\BusinessClientBank;
use Exception;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Illuminate\View\View;

class BankController extends Controller
{
    
    /**
     * Shows a form for creates a new Bank from a business client internal
     * @param Request $request Request informatión
     * @param mixed $id business client internal Id
     * @return View|Factory view for create a bank
     */
    public function create(Request $request, $id) {
        $bank = new BusinessClientBank();
        $business = BusinessClient::find($id);
        return view('admin.business-client-bank', [
            'business' => $business,
            'bank' => $bank
        ]);
    }

    /**
     * Shows a form for edit a specified bank
     * @param Request $request Request information
     * @param mixed $id Bank id
     * @return View|Factory  View for edit a bank
     */
    public function edit(Request $request, $id) {
        $bank = BusinessClientBank::find($id);
        return view('admin.business-client-bank', [
            'business' => $bank->businessClient,
            'bank' => $bank
        ]);
    }

    /**
     * Saves a bank
     * @param Request $request Request information
     * @return Redirector|RedirectResponse redirect to edit a internal 
     *  business client
     */
    public function store(Request $request) {
        $bank = new BusinessClientBank();
        if ($request['id'] != null) {
            $bank = BusinessClientBank::find($request['id']);
        }
        $bank->name = $request['name'];
        $bank->business_client_id = $request['business-id'];
        $bank->save();

        Cache::put('message', 'Se salvo correctamente el banco' . $bank->name);
        return redirect('/admin/internal-business-clients/' 
            . $bank->business_client_id . '/edit');
    }

    /**
     * Deletes a bank
     * @param Request $request Request information
     * @return Redirector|RedirectResponse redirect to edit a internal 
     *  business client
     * @throws Exception 
     */
    public function destroy(Request $request) {
        $bank = new BusinessClientBank();
        if ($request['id'] != null) {
            $bank = BusinessClientBank::find($request['id']);
        }
        $bank->delete();
        Cache::put('message', 'El banco ha sido dado de baja');
        return redirect('/admin/internal-business-clients/' 
            . $bank->business_client_id . '/edit');
    }
}
