<?php

namespace App\Http\Controllers\Imports;

use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Concerns\WithConditionalSheets;

/**
 * Used to import excel data
 */
class MapperSheetImport implements WithMultipleSheets {

    /**
     * Eexcel sheets
     */
    public $mapper;

    /**
     * sheet index
     */
    public $sheet;
    
    /**
     * init sheets with his map
     */
    public function setSheet($sheet, $map) {
        $this->sheet = $sheet;
        $this->mapper = new MapperImport();
        $this->mapper->map = $map;
    }

    /**
     * Manages the sheets
     */
    public function sheets(): array {
        return [
            $this->sheet => $this->mapper
        ];
    }

    public function getResponse() {
        return $this->mapper->response;
    }
}
