<?php

namespace App\Http\Controllers\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

/**
 * Used to import excel data
 */
class MapperImport implements ToCollection
{

    /**
     * Map to handle
     */
    public $map = [];

    /**
     * Response data
     */
    public $response = [];

    /**
     * Collection data to import from rows
     */
    public function collection(Collection $rows) {
        $rowNumber = 1;
        foreach ($rows as $row) {
            $data = [];
            foreach ($this->map as $i) {
                $columnIndex = $this->getColumnIndex($i['column']);
                if ($columnIndex < count($row)) {
                    $data[$i['target']] = $row[$columnIndex];
                }
            }
            array_push($this->response, $data);
            $rowNumber++;
        }
    }

    /**
     * Column index to load
     * @param key Key to calculate
     */
    private function getColumnIndex($key) {
        $index = 0;
        for ($i = 0, $l = strlen($key)-1; $i < strlen($key); $i++, $l--) {
            $c = ord(strtolower($key[$l])) - 97;

            if ($i > 0) {
                $index += pow(26, $i) * ($c + 1);
            } else {
                $index += $c;
            }
        }
        return $index;
    }
}
