<?php

namespace App\Http\Controllers\Imports;

use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithMappedCells;

/**
 * Used to import excel data
 */
class MapperCellImport implements WithMappedCells, ToModel {

    /**
     * Response data
     */
    public $response = [];

    public function mapping(): array 
    {
        return [
            'code' => 'A2',
            'name' => 'B2'
        ];
    }

    public function model(array $row)
    {
        $model = array(
            'code' => $row['code'],
            'name' => $row['name'],
        );
        return $model;
    }

}
