<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Model\User;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    
    public function get(Request $request) {
        $user = User::find(Auth::id());
        if ($user->type == 'CU') {
            return redirect('/client/requests');
        }
        if (Auth::user()->hasAuth("PARTNERSHIPS")) {
            return redirect('/admin/partnerships');
        } else if (Auth::user()->hasAuth("INTERNAL_CUSTOMERS")) {
            return redirect('/admin/internal-business-clients');
        } else if (Auth::user()->hasAuth("EXTERNAL_CUSTOMERS")) {
            return redirect('/admin/external-business-clients');
        } else if (Auth::user()->hasAuth("EMPLOYEES")) {
            return redirect('/admin/employees');
        } else if (Auth::user()->hasAuth("ISR_PERIODS")) {
            return redirect('/admin/isr-periods');
        } else if (Auth::user()->hasAuth("USERS")) {
            return redirect('/admin/users');
        } else if (Auth::user()->hasAuth("INVOICES")) {
            return redirect('/tax-documents/invoices');
        } else if (Auth::user()->hasAuth("ASSIMILATED_RECEIPTS")) {
            return redirect('/payroll/assimilated-employees');
        } else if (Auth::user()->hasAuth("SALARIED_RECEIPTS")) {
            return redirect('/payroll/assimilated-employees');
        }
        return redirect('/admin/partnerships');
    }

    /**
     * Toogle menu view
     */
    public function toggleMenu(Request $request) {
        $request->session()->put('collapsed',
            !$request->session()->get('collapsed', false));
        return back();
    }
}
