<?php

namespace App\Http\Controllers\Exports;

use Exception;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
use Maatwebsite\Excel\DefaultValueBinder;
use PhpOffice\PhpSpreadsheet\Cell\Cell;
use PhpOffice\PhpSpreadsheet\Cell\DataType;

class ScatterExports extends DefaultValueBinder implements WithCustomValueBinder, FromQuery, WithMapping, WithHeadings
{
    use Exportable;

    public $query;
    public $receipts;

    public function headings(): array {
        return [
            'RFC',
            'Titular',
            'Método de pago',
            'Emisor',
            'Banco',
            'SYS',
            'AS',
            'Importe',
            'No. Cuenta / Clabe interbancaria',
            'Tipo',
            'Monto Pagado'
        ];
    }

    public function query() {
        return $this->query
            ->orderBy('employees.name')
            ->with('scatterDetails');
    }

    public function map($employee): array {
        $sys = '';
        $as = '';
        if (count($employee->scatterDetails) == 1) {
            $sys = $employee->sys;
            $as = $employee->as;
        }
        
        $name = $employee->employee->businessClient ? $employee->employee->businessClient->name : '';
        return [
            $employee->employee->rfc,
            $employee->employee->full_name,
            'TRANSFERENCIA',
            $name,
            $employee->bank != null ? $employee->bank->name : '',
            $sys,
            $as,
            $employee->amount + $employee->getPendingAmount(),
            $employee->account,
            $employee->employee->getType(),
            $employee->getPayedAmount()
        ];
    }

    public function bindValue(Cell $cell, $value)
    {
        if ($cell->getColumn() == 'I') {
            $cell->setValueExplicit($value, DataType::TYPE_STRING);
            return true;
        }
        return parent::bindValue($cell, $value);
    }
}
