<?php

namespace App\Http\Controllers\Exports;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\DefaultValueBinder;

class ReceiptExport extends DefaultValueBinder implements FromCollection, WithMapping, WithHeadings
{
    use Exportable;

    public $query;

    public $data;

    public function collection() { 
        return collect($this->data);
    }

    public function headings(): array {
        return [
            'Folio',
            'UUID',
            'Tipo',
            'Fecha y hora',
            'RFC Emisor',
            'Nombre Emisor',
            'RFC Receptor',
            'Nombre Receptor',
            'Estado',
            'Subtotal',
            'ISR Retenido',
            'Subsidio',
            'IMSS',
            'Infonavit',
            'Total'
        ];
    }

    public function map($receipt): array {
        return [
            $receipt->code,
            $receipt->uuid, 
            $receipt->type,
            $receipt->stamped_at,
            $receipt->rfcEmissor,
            $receipt->emissor,
            $receipt->rfc,
            $receipt->receiver,
            $receipt->status,
            '$' . number_format($receipt->subtotal, 2),
            '$' . number_format($receipt->isr, 2),
            '$' . number_format($receipt->subsidio, 2),
            '$' . number_format($receipt->imss, 2),
            '$' . number_format($receipt->infonavit, 2),
            '$' . number_format($receipt->total, 2)
        ];
    }

}
