<?php

namespace App\Http\Controllers\Exports;

use Exception;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
use Maatwebsite\Excel\DefaultValueBinder;
use PhpOffice\PhpSpreadsheet\Cell\Cell;
use PhpOffice\PhpSpreadsheet\Cell\DataType;

class PaymentScatterExports extends DefaultValueBinder implements WithCustomValueBinder, FromQuery, WithMapping, WithHeadings
{
    use Exportable;

    public $query;
    public $receipts;

    public function headings(): array {
        return [
            'RFC',
            'Titular',
            'Método de pago',
            'Emisor',
            'Banco',
            'Importe',
            'SYS',
            'AS',
            'No. Cuenta / Clabe interbancaria',
            'Tipo',
            'Pagado/No Pagado'
        ];
    }

    public function query() {
        return $this->query
            ->orderBy('scatter_details.request_file_id', 'asc')
            ->orderBy('employees.name', 'asc');
    }

    public function map($detail): array {
        $sys = '';
        $as = '';
        if (count($detail->employeeScatter->scatterDetails) == 1) {
            $sys = $detail->employeeScatter->sys;
            $as = $detail->employeeScatter->as;
        }

        $name = $detail->employeeScatter->employee->businessClient ? $detail->employeeScatter->employee->businessClient->name : '';
        return [
            $detail->employeeScatter->employee->rfc,
            $detail->employeeScatter->employee->full_name,
            'TRANSFERENCIA',
            $name,
            $detail->employeeScatter->bank != null ? $detail->employeeScatter->bank->name : '',
            $detail->amount,
            $sys,
            $as,
            $detail->employeeScatter->account,
            $detail->employeeScatter->employee->getType(),
            $detail->requestFile ? 'Pagado' : ''
        ];
    }

    public function bindValue(Cell $cell, $value)
    {
        if ($cell->getColumn() == 'I') {
            $cell->setValueExplicit($value, DataType::TYPE_STRING);
            return true;
        }
        return parent::bindValue($cell, $value);
    }
}
