<?php

namespace App\Http\Controllers\Exports;

use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use PhpOffice\PhpSpreadsheet\Cell\Cell;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use Maatwebsite\Excel\DefaultValueBinder;

class EmployeeExports extends DefaultValueBinder implements WithCustomValueBinder, FromQuery, WithMapping, WithHeadings
{
    use Exportable;

    public $query;

    public function headings(): array {
        return [
            'Consorcio',
            'Apellido paterno',
            'Apellido materno',
            'Nombre',
            'Curp',
            'RFC',
            'Neto a Pagar',
            'Banco',
            'Cuenta bancaria/Numero de tarjeta'
        ];
    }

    public function query() {
        return $this->query
            ->orderBy('employees.partnership_id')
            ->orderBy('employees.employee_number');
    }

    public function map($employee): array {
        return [
            $employee->partnership->code,
            $employee->last_name,
            $employee->last_name2,
            $employee->name,
            $employee->curp,
            $employee->rfc,
            '',
            $employee->bank ? $employee->bank->name : '',
            $employee->account
        ];
    }

    public function bindValue(Cell $cell, $value)
    {
        if ($cell->getColumn() == 'I') {
            $cell->setValueExplicit($value, DataType::TYPE_STRING);
            return true;
        }
        return parent::bindValue($cell, $value);
    }
}
