<?php

namespace App\Http\Controllers\Exports;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use App\Model\Employee;

class ClientEmployeesExports implements FromQuery, WithMapping, WithHeadings
{
    use Exportable;

    public $query;

    public function headings(): array {
        return [
            'RFC Empleado',
            'Titular',
            'Método de pago',
            'Banco',
            'Importe',
            'No. Cuenta/Clave interbancaria',
            '',
            '',
            'Tipo'
        ];
    }

    public function query() {
        return $this->query
            ->orderBy('employees.name');
    }

    public function map($employee): array {
        return [
            $employee->employee->rfc,
            $employee->employee->getFullName(),
            'TRANSFERENCIA',
            '',
            '',
            '',
            0,
            0,
            'Colaborador'
        ];
    }
}
