<?php

namespace App\Http\Controllers\Exports;

use App\Model\EmployeeScatter;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\DefaultValueBinder;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Cell\Cell;

class AssimilatedExport extends DefaultValueBinder implements WithCustomValueBinder, FromQuery, WithMapping, WithHeadings
{
    use Exportable;

    public $query;

    public function headings(): array {
        return [
            'Consorcio',
            'Apellido Paterno',
            'Apellido Materno',
            'Nombre',
            'CURP',
            'RFC',
            'Neto a Pagar',
            'Solicitud'
        ];
    }

    public function query() {
        return $this->query;
    }

    public function map($employeeScatter): array {
        return [
            $employeeScatter->request->businessClient->partnership->code,
            $employeeScatter->employee->last_name, 
            $employeeScatter->employee->last_name2, 
            $employeeScatter->employee->name, 
            $employeeScatter->employee->curp, 
            $employeeScatter->employee->rfc, 
            round($employeeScatter->as - $employeeScatter->payed_as, 2),
            $employeeScatter->request->code
        ];
    }

    public function bindValue(Cell $cell, $value)
    {
        /*
        if ($cell->getColumn() == 'G') {
            $cell->setValueExplicit($value, DataType::TYPE_NUMERIC);
            return true;
        }*/
        return parent::bindValue($cell, $value);
    }

}
