<?php

namespace App\Http\Controllers\ClientBusiness;

use App\Http\Controllers\Controller;
use App\Model\BusinessClient;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use ZipArchive;

class DownloadController extends Controller
{
    
    /**
     * Downloads a zip package
     */
    public function downloadFiles(Request $request, $id) {
        set_time_limit(300);
        
        $business = BusinessClient::find($id);
        
        $zipName = 'documentos.zip';
        if (Storage::disk('zips')->exists($zipName)) {
            Storage::disk('zips')->delete($zipName);
        }
        $storagePath  = Storage::disk('zips')->getDriver()->getAdapter()->getPathPrefix();
        $zipper = new ZipArchive();
        if ($zipper->open($storagePath . $zipName, ZipArchive::CREATE) === TRUE) {
            if ($business->rfc_file) {
                Storage::disk('zips')->put('documentos/rfc/' . $business->getRFCFile(), 
                    Storage::disk('s3')->get($business->rfc_file));
                $zipper->addFile($storagePath . 'documentos/rfc/' . $business->getRFCFile(), 
                    'rfc/' . $business->getRFCFile());
            }
            if ($business->address_file) {
                Storage::disk('zips')->put('documentos/address/' . $business->getAddressFile(), 
                    Storage::disk('s3')->get($business->address_file));
                $zipper->addFile($storagePath . 'documentos/address/' . $business->getAddressFile(), 
                    'address/' . $business->getAddressFile());
            }
            if ($business->constitutive_act_file) {
                Storage::disk('zips')->put('documentos/constitutiveact/' . $business->getConstitutiveActFile(), 
                    Storage::disk('s3')->get($business->constitutive_act_file));
                $zipper->addFile($storagePath . 'documentos/constitutiveact/' . $business->getConstitutiveActFile(), 
                    'constitutiveact/' . $business->getConstitutiveActFile());
            }
            if ($business->ife_file) {
                Storage::disk('zips')->put('documentos/ife/' . $business->getIFEFile(), 
                    Storage::disk('s3')->get($business->ife_file));
                $zipper->addFile($storagePath . 'documentos/ife/' . $business->getIFEFile(), 
                    'ife/' . $business->getIFEFile());
            }
            if ($business->identification_card_file) {
                Storage::disk('zips')->put('documentos/identificationcard/' . $business->getIdentificationCardFile(), 
                    Storage::disk('s3')->get($business->identification_card_file));
                $zipper->addFile($storagePath . 'documentos/identificationcard/' . $business->getIdentificationCardFile(), 
                    'identificationcard/' . $business->getIdentificationCardFile());
            }
            if ($business->main_identification_card_file) {
                Storage::disk('zips')->put('documentos/mainidentificationcard/' . $business->getMainIdentificationCardFile(), 
                    Storage::disk('s3')->get($business->main_identification_card_file));
                $zipper->addFile($storagePath . 'documentos/mainidentificationcard/' . $business->getMainIdentificationCardFile(), 
                    'mainidentificationcard/' . $business->getMainIdentificationCardFile());
            }

            $zipper->close();
            if (Storage::disk('zips')->exists('documentos')) {
                Storage::disk('zips')->deleteDirectory('documentos');
            }
        }

        if ($business) {
            $storagePath  = Storage::disk('zips')->getDriver()
                    ->getAdapter()->getPathPrefix();
            if (Storage::disk('zips')->exists($zipName)) {
                return response()->download($storagePath . $zipName);
            }     
        }
        return redirect()->back()->withInput($request->input());
    }

}
