<?php

namespace App\Http\Controllers\ClientBusiness;

use App\Http\Controllers\Controller;
use App\Model\BusinessClient;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class BusinessController extends Controller
{
    
    /**
     * List all partnership business
     */
    public function index(Request $request) {
        $partnership = Auth::user()->partnership();
        
        $page = $request->input('page', 0);
        $search = $request->input('search');
        $sort = 'status';
        $sortOrientation = 'asc';
        $sortTokens = $request->input('sort', 'status:asc');
        if (strpos($sortTokens, ':') != false) {
            list($sort, $sortOrientation) = explode(':', $sortTokens);
        } else {
            $sort = $sortTokens;
        }

        $query = BusinessClient::where('partnership_id', $partnership->id)
            ->whereNull('canceled_at')
            ->orderBy($sort, $sortOrientation);

        if ($search) {
            $query = $query->where(function ($query) use($search) {
                $query->where('name', 'like', '%' . $search . '%');
            });
        }
        $total = $query->count();
        return view('client.business-index', [
            'data' => $query->skip($page * 25)->take(25)->get(),
            'total' => $total,
            'page' => $page,
            'search' => $search,
            'sort' => $sort,
            'sortOrientation' => $sortOrientation,
            'pages' => ceil($total / 25)
        ]);
    }

    /**
     * Shows a form for create a new client request
     * @param Request $request 
     * @return void 
     */
    public function create(Request $request) {
        $business = new BusinessClient();
        
        return view('client.new-business', [
            'business' => $business
        ]);
    }

    public function store(Request $request) {
        $partnership = Auth::user()->partnership();

        $record = new BusinessClient();
        $record->type= 'E';

        if ($request->has('id')) {
            $record = BusinessClient::find($request->input('id'));
        }
        
        $record->name = $request->input('name');
        $record->code = $request->input('rfc');
        $record->rfc = strtoupper($request->input('rfc'));
        $record->client_type = $request->input('type');
        $record->address = $request->input('address');
        $record->status = 'O';
        $record->partnership()->associate($partnership);
        $record->save();
        
        if ($request->hasFile('rfc-file')) {
            $file = $request->file('rfc-file');
            $record->rfc_file = 'partnerships' . '/' . $record->partnership->code . '/' . $record->code 
                . '/rfc/' . $file->getClientOriginalName();
            $record->save();
            
            $fileContent = file_get_contents($file->getRealPath());
            Storage::disk('s3')->put($record->rfc_file, $fileContent);
        }
        if ($request->hasFile('address-file')) {
            $file = $request->file('address-file');
            $record->address_file = 'partnerships' . '/' . $record->partnership->code . '/' . $record->code 
                . '/address/' . $file->getClientOriginalName();
            $record->save();
            
            $fileContent = file_get_contents($file->getRealPath());
            Storage::disk('s3')->put($record->address_file, $fileContent);
        }
        if ($request->hasFile('address-file')) {
            $file = $request->file('address-file');
            $record->address_file = 'partnerships' . '/' . $record->partnership->code . '/' . $record->code 
                . '/address/' . $file->getClientOriginalName();
            $record->save();
            
            $fileContent = file_get_contents($file->getRealPath());
            Storage::disk('s3')->put($record->address_file, $fileContent);
        }
        if ($request->hasFile('constitutive-act-file')) {
            $file = $request->file('constitutive-act-file');
            $record->constitutive_act_file = 'partnerships' . '/' . $record->partnership->code . '/' . $record->code 
                . '/constitutiveact/' . $file->getClientOriginalName();
            $record->save();
            
            $fileContent = file_get_contents($file->getRealPath());
            Storage::disk('s3')->put($record->constitutive_act_file, $fileContent);
        }
        if ($request->hasFile('ife-file')) {
            $file = $request->file('ife-file');
            $record->ife_file = 'partnerships' . '/' . $record->partnership->code . '/' . $record->code 
                . '/ife/' . $file->getClientOriginalName();
            $record->save();
            
            $fileContent = file_get_contents($file->getRealPath());
            Storage::disk('s3')->put($record->ife_file, $fileContent);
        }
        if ($request->hasFile('identification-card-file')) {
            $file = $request->file('identification-card-file');
            $record->identification_card_file = 'partnerships' . '/' . $record->partnership->code . '/' . $record->code 
                . '/identificationcard/' . $file->getClientOriginalName();
            $record->save();
            
            $fileContent = file_get_contents($file->getRealPath());
            Storage::disk('s3')->put($record->identification_card_file, $fileContent);
        }
        if ($request->hasFile('main-identification-card-file')) {
            $file = $request->file('main-identification-card-file');
            $record->main_identification_card_file = 'partnerships' . '/' . $record->partnership->code 
                . '/' . $record->code . '/mainidentificationcard/' . $file->getClientOriginalName();
            $record->save();
            
            $fileContent = file_get_contents($file->getRealPath());
            Storage::disk('s3')->put($record->main_identification_card_file, $fileContent);
        }

        if ($request->hasFile('rfc-physical-file')) {
            $file = $request->file('rfc-physical-file');
            $record->rfc_file = 'partnerships' . '/' . $record->partnership->code . '/' . $record->code 
                . '/rfc/' . $file->getClientOriginalName();
            $record->save();
            
            $fileContent = file_get_contents($file->getRealPath());
            Storage::disk('s3')->put($record->rfc_file, $fileContent);
        }
        if ($request->hasFile('address-physical-file')) {
            $file = $request->file('address-physical-file');
            $record->address_file = 'partnerships' . '/' . $record->partnership->code . '/' . $record->code 
                . '/address/' . $file->getClientOriginalName();
            $record->save();
            
            $fileContent = file_get_contents($file->getRealPath());
            Storage::disk('s3')->put($record->address_file, $fileContent);
        }
        if ($request->hasFile('identification-physical-card-file')) {
            $file = $request->file('identification-physical-card-file');
            $record->identification_card_file = 'partnerships' . '/' . $record->partnership->code . '/' . $record->code 
                . '/identificationcard/' . $file->getClientOriginalName();
            $record->save();
            
            $fileContent = file_get_contents($file->getRealPath());
            Storage::disk('s3')->put($record->identification_card_file, $fileContent);
        }
        Cache::put('message', 'Se salvo correctamente la empresa');
        return redirect('/client/business/' . $record->id . '/edit');
    }

    public function edit(Request $request, $id) {
        $business = BusinessClient::find($id);
        
        return view('client.new-business', [
            'business' => $business
        ]);
    }

    /**
     * Stores a invoice of a client
     * @param Request $request Request data
     * @return void 
     */
    public function sendBusiness(Request $request, $id) {
        $record = BusinessClient::find($id);

        $record->status = 'P';
        $record->save();
        Cache::put('message', 'La empresa se envio correctamente');
        return redirect('/client/business/' . $record->id . '/edit');
    }
}
