<?php

namespace App\Http\Controllers;

use App\Http\Services\DocumentServices;
use Illuminate\Http\Request;

class CFDIController extends Controller
{

    /**
     * Build CFDI from data
     * @param request Request data to scheck
     */
    public function buildCFDI(Request $request) {
        if (!$request->has('data')) {
            return response('<error>Property [data] not found</error>', 200, [
                'Content-Type' => 'application/xml'
            ]);
        }
        if (!$request->has('data.Folio')) {
            return response(
                '<error>Property [data.Folio] not found</error>', 200, [
                'Content-Type' => 'application/xml'
            ]);
        }
        if (!$request->has('data.Fecha')) {
            return response(
                '<error>Property [data.Fecha] not found</error>', 200, [
                'Content-Type' => 'application/xml'
            ]);
        }
        if (!$request->has('data.Emisor.Rfc')) {
            return response(
                '<error>Property [data.Emisor.Rfc] not found</error>', 200, [
                'Content-Type' => 'application/xml'
            ]);
        }
        if (!$request->has('data.Emisor.Nombre')) {
            return response(
                '<error>Property [data.Emisor.Nombre] not found</error>', 200, [
                'Content-Type' => 'application/xml'
            ]);
        }
        if (!$request->has('data.Receptor.Rfc')) {
            return response(
                '<error>Property [data.Receptor.Rfc] not found</error>', 200, [
                'Content-Type' => 'application/xml'
            ]);
        }
        if (!$request->has('data.Receptor.Nombre')) {
            return response(
                '<error>Property [data.Receptor.Nombre] not found</error>',
                    200, [
                'Content-Type' => 'application/xml'
            ]);
        }
        $subtotal = $request->json('data')['nomina']['subtotal'];
        $lowerLimits = $request->json('data')['isr']['LimiteInferior'];
        $uperLimits = $request->json('data')['isr']['LimiteSuperior'];
        $fixedFees = $request->json('data')['isr']['CuotaFija'];
        $surplusLowerLimits = $request->json('data')['isr']['ExcedenteLimiteInferior'];
        
        $lowerLimit = 0;
        $percentLowerLimit = 0;
        $fixedFee = 0;
        for ($i = 0; $i < count($lowerLimits); $i++) {
            if ($lowerLimits[$i] <= $subtotal) {
                $lowerLimit = $lowerLimits[$i];
                $percentLowerLimit = $surplusLowerLimits[$i];
                $fixedFee = $fixedFees[$i];
            } else {
                break;
            }
        }
        $surplus = abs($lowerLimit - $subtotal);
        $impMarg = $surplus * $percentLowerLimit;
        $impRet = $impMarg + $fixedFee;
        $isr = $subtotal - $impRet;

        $data = $request->json('data');
        unset($data['isr']);
        $data['nomina']['isr'] = round($isr, 2);
        $data['nomina']['total'] = round($isr + $subtotal, 2);

        $cfdi = DocumentServices::buildCFDI($data);
        return response($cfdi, 200, [ 'Content-Type' => 'application/xml' ]);
    }

    public function getCFDI($data) {
        $subtotal = $data['nomina']['subtotal'];
        $lowerLimits = $data['isr']['LimiteInferior'];
        $uperLimits = $data['isr']['LimiteSuperior'];
        $fixedFees = $data['isr']['CuotaFija'];
        $surplusLowerLimits = $data['isr']['ExcedenteLimiteInferior'];
        
        $lowerLimit = 0;
        $percentLowerLimit = 0;
        $fixedFee = 0;
        for ($i = 0; $i < count($lowerLimits); $i++) {
            if ($lowerLimits[$i] <= $subtotal) {
                $lowerLimit = $lowerLimits[$i];
                $percentLowerLimit = $surplusLowerLimits[$i];
                $fixedFee = $fixedFees[$i];
            } else {
                break;
            }
        }
        $surplus = abs($lowerLimit - $subtotal);
        $impMarg = $surplus * $percentLowerLimit;
        $impRet = $impMarg + $fixedFee;
        $isr = $subtotal - $impRet;

        unset($data['isr']);
        $data['nomina']['isr'] = round($isr, 2);
        $data['nomina']['total'] = round($isr + $subtotal, 2);

        $cfdi = DocumentServices::buildCFDI($data);
        $domxml = new \DOMDocument('1.0');
        $domxml->preserveWhiteSpace = false;
        $domxml->formatOutput = true;
        $domxml->loadXML($cfdi);
        return response($domxml->saveXML(), 200, [ 'Content-Type' => 'text/plain' ]);
     }
}
