<?php

namespace App\Http\Controllers\Bills;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Exports\ReceiptExport;
use App\Model\BusinessClient;
use App\Model\PayrollReceipt;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;
use File;
use Illuminate\Support\Facades\DB;

class DownloadPayrollController extends Controller
{
    
    public function getQuery(Request $request) {
        $filter = $request->input('filter');

        $clientName = $request->input('client-name', null);
        $from = new Carbon();
        $from->startOfMillennium();
        $to = new Carbon();
        $to->endOfMillennium();

        if ($request->has('from') && !empty($request->get('from'))) {
            $from = new Carbon($request->input('from'));
            $from->startOfDay();
            Session::put('from', $from->format('Y-m-d'));
        } else if (Session::has('from')) {
            $from = new Carbon(Session::get('from'));
            $from->startOfDay();
        }
        if ($request->has('to') && !empty($request->get('to'))) {
            $to = new Carbon($request->input('to'));
            $to->endOfDay();
            Session::put('to', $to->format('Y-m-d'));
        } else if (Session::has('to')) {
            $to = new Carbon(Session::get('to'));
            $to->endOfDay();
        }

        $dbFrom = $from->format('Y-m-d');
        $dbTo = $to->format('Y-m-d');

        $query = "select pr.id, pr.code, pr.uuid, 'AS' type, DATE_FORMAT(pr.stamped_at, '%Y-%m-%d %H:%i') stamped_at, 
                    p.rfc rfcEmissor, p.name emissor, pr.rfc, concat(pr.name, ' ', pr.last_name, ' ', pr.last_name2) receiver, 
                    case when pr.canceled_at is not null then 'Cancelado'
                        when pr.uuid is not null then 'Vigente'
                        else 'No timbrado'
                    end status, pr.total, pr.subtotal, pr.isr, 0 subsidio, 0 imss, 0 infonavit
                from payroll_receipts pr
                join payrolls p on p.id = pr.payroll_id
                where pr.uuid is not null and pr.stamped_at between '$dbFrom' and '$dbTo'";
        if ($filter) {
            $query .= " and (concat(pr.name, ' ', pr.last_name, ' ', pr.last_name2) like '%$filter%'
                or pr.rfc like '%$filter%'
                or pr.uuid like '%$filter%')";
        }
        $query .= " UNION ";
        $query .= " select i.id, i.code, i.uuid, 'Factura' type, DATE_FORMAT(i.stamped_at, '%Y-%m-%d %H:%i') stamped_at, e.rfc rfcEmissor, e.name emissor, r.rfc, r.name receiver, 
                    case when i.canceled_at is not null then 'Cancelado'
                        when i.uuid is not null then 'Vigente'
                        else 'No timbrado'
                    end status, i.total, i.subtotal, 0 isr, 0 subsidio, 0 imss, 0 infonavit
                from invoices i
                join business_clients e on e.id = i.emissor_id
                join business_clients r on r.id = i.receiver_id
                where i.uuid is not null and i.stamped_at between '$dbFrom' and '$dbTo'";
        if ($filter) {
            $query .= " and (e.name like '%$filter%'
                or r.name like '%$filter%'
                or r.rfc like '%$filter%' 
                or i.uuid like '%$filter%')";
        }
        $query .= " UNION ";
        $query .= "select pr.id, pr.code, pr.uuid, 'SYS' type, DATE_FORMAT(pr.stamped_at, '%Y-%m-%d %H:%i') stamped_at, 
                    em.rfc rfcEmissor, em.name emissor, pr.rfc, concat(pr.first_name, ' ', pr.middle_name, ' ', pr.last_name) receiver, 
                    case when pr.canceled_at is not null then 'Cancelado'
                        when pr.uuid is not null then 'Vigente'
                        else 'No timbrado'
                    end status, pr.total, (pr.total - pr.isr - pr.imss - pr.infonavit)  subtotal, pr.isr, pr.subsidy_c subsidio, pr.imss, pr.infonavit
                from payroll_worker_receipts pr
                join payroll_workers p on p.id = pr.payroll_worker_id
                join requests r on r.id = p.request_id
                join employees e on e.id = pr.employee_id
                join business_clients em on em.id = e.business_client_id
                where p.deleted_at is null and pr.deleted_at is null and r.deleted_at is null
                    and pr.uuid is not null and pr.stamped_at between '$dbFrom' and '$dbTo'";
        if ($filter) {
            $query .= " and (concat(pr.first_name, ' ', pr.middle_name, ' ', pr.last_name) like '%$filter%'
                or pr.rfc like '%$filter%' 
                or pr.uuid like '%$filter%')";
        }
        return $query;
    }

    /**
     * List all partnership business
     */
    public function index(Request $request) {    
        $page = $request->input('page', 0);
        $filter = $request->input('filter');

        $clientName = $request->input('client-name', null);
        $from = new Carbon();
        $from->startOfMillennium();
        $to = new Carbon();
        $to->endOfMillennium();

        if ($request->has('from') && !empty($request->get('from'))) {
            $from = new Carbon($request->input('from'));
            $from->startOfDay();
            Session::put('from', $from->format('Y-m-d'));
        } else if (Session::has('from')) {
            $from = new Carbon(Session::get('from'));
            $from->startOfDay();
        }
        if ($request->has('to') && !empty($request->get('to'))) {
            $to = new Carbon($request->input('to'));
            $to->endOfDay();
            Session::put('to', $to->format('Y-m-d'));
        } else if (Session::has('to')) {
            $to = new Carbon(Session::get('to'));
            $to->endOfDay();
        }
        
        $query = $this->getQuery($request);

        $total = DB::select("select coalesce(count(id), 0) count
        from ( $query ) a")[0]->count;

        $startPage = $page * 25;
        $data = DB::select("select * from ( $query ) a order by stamped_at desc limit $startPage, 25");

        $dummyStart = new Carbon();
        $dummyStart->startOfMillennium();
        $dummyEnd = new Carbon();
        $dummyEnd->endOfMillennium();
        $clients = BusinessClient::where('type', 'I')
            ->whereNull('canceled_at')
            ->orderBy('name')
            ->get();

        return view('invoices.payroll-index', [
            'data' => $data,
            'clients' => $clients,
            'clientName' => $clientName,
            'filter' => $filter,
            'total' => $total,
            'page' => $page,
            'pages' => ceil($total / 25),
            'from' => $from->equalTo($dummyStart) ? null : $from,
            'to' => $to->equalTo($dummyEnd) ? null : $to
        ]);
    }

    /**
     * List all partnership business
     */
    public function export(Request $request) {
        set_time_limit(600);
        
        $query = $this->getQuery($request);

        $export = new ReceiptExport();
        $export->data = DB::select("select * from ( $query ) a order by stamped_at desc limit 2000");

        return $export->download('recibos.xlsx');
    }

}
