<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Model\CategoryAuthorization;
use App\Model\PartnershipContact;
use App\Model\User;
use App\Model\UserAuthorization;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

use function PHPSTORM_META\type;

class UserController extends Controller
{

    /**
     * Execute command
     * @param request Controller request
     */
    public function command(Request $request) {
        if ($request->input('action') === 'search') {
            $request->merge(['page-index' => 0]);
            return $this->index($request);
        } else if ($request->input('action') === 'search-page') {
            return $this->index($request);
        } else if ($request->input('action') === 'destroy') {
            return $this->destroy($request);
        } else if ($request->input('action') === 'export') {
            return $this->export($request);
        } else if ($request->input('action') === 'store') {
            return $this->store($request);
        } else if ($request->input('action') === 'create') {
            return $this->create($request);
        } else if (substr($request->input('action'), 0, 11) === 'store-auth-') {
            return $this->storeAuths($request);
        } else if ($request->input(('action')) === 'store-contact-user') {
            return $this->storeContactUser($request);
        }
        return redirect()->back()->withInput($request->input());
    }

    /**
     * Creates a query throught Request inputs
     */
    public function getQuery(Request $request) {
        $filter = $request->input('filter', null);
        $type = ($request->input('type', 'A'));

        $query = User::select('*');
        if (!empty($filter)) {
            $query = $query->where(function ($query) use($filter) {
                $query->where(DB::raw('concat(name, " ", ' 
                        . 'last_name, " ", second_last_name)'), 
                    'like', '%' . $filter . '%')
                    ->orWhere('user_name', 'like', '%' . $filter . '%');
            });
        }
        if ($type != 'A') {
            $query->where('type', $type);
        } else {
            $query->where('type', '<>', 'CU');
        }
        return $query;
    }

    /**
     * Retrieves a list of users
     * @param request Request data
     */
    public function index(Request $request) {
        $page = $request->input('page-index', 0);
        $filter = $request->input('filter', null);
        $type = ($request->input('type', 'A'));

        $query = $this->getQuery($request);
        
        $total = $query->count('users.id');
        
        $query->orderBy('id')
            ->offset($page * 25)
            ->limit(25);
        $totalPages = floor($total / 25) + ($total % 25 !== 0 ? 1 : 0);
        $pages = [ $page ];
        for ($i = $page - 1; $i >= 0 && $i >= $page - 2; $i--) {
            array_unshift($pages, $i);
        }
        for ($i = $page + 1; $i < $totalPages && count($pages) < 5; $i++) {
            array_push($pages, $i);
        }

        return view('admin.user-index', [
            'users' => $query->get(),
            'total' => $total,
            'filter' => $filter,
            'page' => $page,
            'pages' => $pages,
            'type' => $type
        ]);
    }

    /**
     * Creates a form for add a new user
     */
    public function create(Request $request) {
        $user = new User();
        return view('auth.register', [
            'user' => $user,
            'categorys' => []
        ]);
    }

    public function createUserFromContact(Request $request, $id) {
        $contact = PartnershipContact::find($id);
        $user = new User();
        $user->name = $contact->name;
        $user->last_name = $contact->second_name;
        $user->second_last_name = $contact->second_last_name;
        $user->email = $contact->email;
        return view('auth.contact-register', [
            'contactId' => $id,
            'user' => $user
        ]);
    }

    private function validStoreUser(Request $request) {
        $id = $request->input('id', 0);
        $query = User::where('user_name', $request->input('user-name'));
        if ($id != 0) {
            $query->where('id', '<>', $id);
        }
        if ($query->count() > 0) {
            Cache::put('warning', 'El nombre de usuario ' .  $request->input('user-name') .
                ' ya esta relacionado a otro usuario');
            return false;
        }
        /*
        $query = User::where('email', $request->input('email'));
        if ($id != 0) {
            $query->where('id', '<>', $id);
        }
        if ($query->count() > 0) {
            Cache::put('warning', 'El E-mail ya se esta usando, por favor ingrese otro');
            return false;
        }*/
        if (strlen($request->input('password')) <= 6) {
            Cache::put('warning', 'La contraseña requiere al menos 7 carácteres');
            return false;
        }
        return true;
    }

    public function storeUser(Request $request) {
        $id = $request->input('id', 0);
        $query = User::where('user_name', $request->input('user-name'));
        if ($id != 0) {
            $query->where('id', '<>', $id);
        }
        if ($query->count() > 0) {
            Cache::put('warning', 'El nombre de usuario ' 
                .  $request->input('user-name') .
                ' ya esta relacionado a otro usuario');
            return null;
        }
        $query = User::where('email', $request->input('email'));
        if ($id != 0) {
            $query->where('id', '<>', $id);
        }
        /*
        if ($query->count() > 0) {
            Cache::put('warning', 'El E-mail ya se esta usando, ' 
                .'por favor ingrese otro');
            return null;
        }*/
        if (strlen($request->input('password')) <= 6) {
            Cache::put('warning', 'La contraseña requiere al menos 7 carácteres');
            return null;
        }
        $user = new User();
        if ($request['id'] != null) {
            $user = User::find($id);
        }
        $user->name = $request->input('name', '');
        $user->last_name = $request->input('last-name', '');
        $user->second_last_name = $request->input('second-last-name', '');
        $user->user_name = $request->input('user-name', '');
        $user->type = $request->input('type');
        $user->email = $request->input('email', '');
        if ($user->password != $request->input('password', '')) {
            $user->password = md5($request->input('password', ''));
        }
        $user->save();
        return $user;
    }

    /**
     * Save a employee
     */
    public function store(Request $request) {
        if (!$this->validStoreUser($request)) {
            return redirect()->back()->withInput($request->input());
        }
        $user = $this->storeUser($request);
        if ($user) {
            Cache::put('message', 'Se salvo correctamente al usuario' . $user->user_name);
            return redirect('/admin/users');
        } else {
            return redirect()->back()->withInput($request->input());
        }        
    }

    public function storeContactUser(Request $request) {
        $user = $this->storeUser($request);
        if ($user) {
            $user->type = 'CU';
            $user->save();

            $contact = PartnershipContact::find($request['contact-id']);
            $contact->user()->associate($user);
            $contact->save();

            Cache::put('message', 'Se salvo correctamente al usuario ' . 
                $user->getFullName());
            return redirect('/admin/partnerships/' . $contact->partnership_id . '/edit');
        } else {
            return redirect()->back()->withInput($request->input());
        }
    }

    public function storeAuths(Request $request) {
        $id = $request->input('id', 0);

        $user = new User();
        if ($request['id'] != null) {
            $user = User::find($id);
        }

        $categoryId = substr($request->input('action'), 11, 1);   
        
        foreach ($user->userAuthorizations as $userAuth) {
            $exist = false;
            if ($request->input('auth-' . $categoryId)) {
                for ($i = 0; $i < count($request->input('auth-' . $categoryId)); $i++) {
                    if ($userAuth->authorization_id == $request->input('auth-' . $categoryId)[$i]) {
                        $exist = true;
                        break;
                    }
                }
            }
            if (!$exist && $userAuth->authorization->category_authorization_id == $categoryId) {
                $userAuth->delete();
            }
        }
        if ($request->input('auth-' . $categoryId)) {
            for ($i = 0; $i < count($request->input('auth-' . $categoryId)); $i++) {
                if (!$user->isActive($request->input('auth-' . $categoryId)[$i])) {
                    $auth = new UserAuthorization();
                    $auth->user()->associate($user);
                    $auth->authorization_id = $request->input('auth-' . $categoryId)[$i];
                    $auth->save();
                }
            }
        }
        return redirect('/admin/users/' . $user->id . '/edit');
    }

    /**
     * Shows a employee form for edit his data
     */
    public function edit(Request $request, $id) {
        $user = User::find($id);
        $categorys = CategoryAuthorization::orderBy('index')->get();
        $currentCategory = $categorys[0];

        return view('auth.register', [
            'user' => $user,
            'categorys' => $categorys,
            'currentCategory' => $currentCategory
        ]);
    }

    public function editContactUser(Request $request, $id) {
        $contact = PartnershipContact::find($id);

        return view('auth.contact-register', [
            'contactId' => $contact->id,
            'user' => $contact->user
        ]);
    }

    /**
     * Remove a user from specified user id
     */
    public function destroy(Request $request) {
        if (!$request->input('selected') || empty($request->input('selected'))) {
            Cache::put('warning', 'Debe seleccionar almenos un usuario');
        } else {
            User::whereIn('id', $request->input('selected'))
                ->delete();
            Cache::put('message', 'Los usuarios han sido dados de baja');
        }
        return redirect('/admin/users');
    }
}
