<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Model\User;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class ResetPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    /**
     * Where to redirect users after resetting their password.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    public function showResetForm(Request $request, $token) {
        $user = User::where('token', $token)->first();
        if (!$user) {
            Cache::put('warning', 'La liga que intenta consultar expiro, favor de generar una nueva');
            return redirect('/password/reset');
        }
        return view('auth.passwords.reset', [
            'email' => $user->email,
            'userName' => $user->user_name,
            'token' => $token
        ]);
    }

    public function reset(Request $request) {
        if (strlen($request->input('password')) <= 6) {
            Cache::put('warning', 'La contraseña requiere al menos 7 carácteres');
            return redirect()->back()->withInput($request->input());
        }
        if ($request->input('password') != $request->input('password_confirmation')) {
            Cache::put('warning', 'Las contraseñas no coinciden');    
            return redirect()->back()->withInput($request->input());
        }
        $user = User::where('token', $request->input('token'))->first();

        $currentUser = User::where('user_name', $request->input('user-name'))
            ->where('id', '!=', $user->id)
            ->first();
        if ($currentUser) {
            Cache::put('warning', 'El nombre de usuario ya se esta usando');
            return redirect()->back()->withInput($request->input());
        }
        $currentUser = User::where('email', $request->input('email'))
            ->where('id', '!=', $user->id)
            ->first();
        if ($currentUser) {
            Cache::put('warning', 'El E-mail ya se esta usando, ' 
                . 'por favor ingrese otro');
            return redirect()->back()->withInput($request->input());
        }
        $user->email = $request->input('email');
        $user->user_name = $request->input('user-name');
        $user->password = md5($request->input('password'));
        $user->token = null;
        $user->save();
        Cache::put('message', 'La contraseña se reestablecio correctamente');
        return redirect('/');
    }
}
