<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\User;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    /**
     * Login request
     * @param request Request data
     */
    public function login(Request $request) {
        Log::info('Logueando');
        if (empty($request->input('user_name'))) {
            Cache::put('warning', 'Debe definir el usuario');
            return redirect()->back()->withInput($request->input());
        }
        if (empty($request->input('password'))) {
            Cache::put('warning', 'Debe definir la contraseña');
            return redirect()->back()->withInput($request->input());
        }

        $user = User::where('user_name', $request->input('user_name'))
            ->where('password', md5($request->input('password')))
            ->first();
        if (!$user) {
            Cache::put('warning', 'Usuario o contraseña incorrectos');
            return redirect()->back()->withInput($request->input());
        }
        Auth::login($user, true);
        return redirect('/index');
    }

    /**
     * Logout current user and navigate to login
     */
    public function logout() {
        Auth::logout();
        return redirect('/');
    }
}
