<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Model\User;
use Carbon\Carbon;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    public function sendResetLinkEmail(Request $request) {
        if (empty($request->input('email'))) {
            Cache::put('warning', 'Debe ingresar una dirección E-Mail');
            return redirect()->back()->withInput($request->input());
        }
        $email = $request->input('email');
        $user = User::where('email', $email)->first();
        if (!$user) {
            Cache::put('warning', 'La dirección E-Mail no esta asociada a ninguna cuenta');
            return redirect()->back()->withInput($request->input());
        }
        $user->token = md5($user->email . Carbon::now());
        $user->save();

        $currentUrl = strstr($request->url(), 'email', true) . 'reset/' . $user->token;
        $data = array(
            'name'=> 'Buen día, ' . $user->getFullName(). ' por favor abra la siguiente liga para restablecer su contraseña', 
            'link' => $currentUrl,
            'body' => '',
            'note' => '',
        );
        Mail::send('emails.email', $data, function($message) use ($user) {
            $message->from('noreply@silifalcon.com', 
                'BB DESPACHO INTEGRAL DE SERVICIOS SA DE CV');
            $message->subject('Restablecimiento de contraseña');

            $message->to(str_replace(" ", "", $user->email));
            
        });
        Cache::put('message', 'Por favor verifique su correo para reestablecer la contraseña');
        return redirect('/');
    }

    
}
