<?php

namespace App\Http\Controllers\Assimilated;

use App\Http\Controllers\Controller;
use App\Http\Controllers\StampController as ControllersStampController;
use App\Http\Services\CertificaCFDI;
use App\Model\Payroll;
use App\Model\PayrollReceipt;
use App\Model\ProcessRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Storage;

class StampController extends Controller
{
    
    /**
     * Stamps receipts of payroll
     */
    public function stampPayroll(Request $request, $importCode) {
        $query = PayrollReceipt::
            join('payrolls', 'payrolls.id', '=', 'payroll_receipts.payroll_id');
        $query->where('payrolls.import_code', $importCode);
        $query->whereNull('payroll_receipts.uuid')
            ->whereNull('payroll_receipts.canceled_at')
            ->whereNull('payroll_receipts.removed_at');

        $payroll = Payroll::where('import_code', $importCode)
                ->get()->first();

        $query->select('payroll_receipts.*');
        $countReceipts = $query->count();

        if ($countReceipts > 0) {            
            $process = new ProcessRequest();
            $process->code = uniqid();
            $process->user_id = Auth::id();
            $process->command = ''; 
            $process->description = '<strong>Cliente: </strong>' . 
                $payroll->businessClient->name;

            $process->progress = 0;
            $process->start();
            $process->setExpireAt(5);
            $process->save();

            $process->command = 'bb:stamp-assimilated ' . $process->id 
                . ' --payroll=' . $importCode;
            $process->save();

            $command = 'php /var/www/html/artisan ' . $process->command;
            if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
                $command = 'start php C:\Workspace\customers\BB\bb\artisan ' 
                    . $process->command . ' > NUL 2> NUL';
                $pid = popen($command, 'r');
                Log::info(pclose($pid));
            } else {
                shell_exec("/usr/bin/nohup ". $command." >/dev/null 2>&1 &");
            }
            return redirect('/stampeds');
        } else {
            Cache::put('warning', 'No existen recibos sin timbrar en esta ' 
                . 'importación');
            return redirect()->back()->withInput($request->input());
        }
    }

    /**
     * Cancel a payroll receipt
     * @param Request $request 
     * @return Illuminate\Routing\Redirector|Illuminate\Http\RedirectResponse 
     */
    public function cancel(Request $request, $id) {
        $receipt = PayrollReceipt::find($id);
        
        set_time_limit(300);
        if ($receipt->isStamped()) {
            $stamp = new ControllersStampController();
            $stamp->cancelPayrollReceipt($receipt);
            
            if (!$receipt->canceled_at) {
                $xml = Storage::disk('s3')->get($receipt->getStampPath() . $receipt->uuid . '.xml');
                CertificaCFDI::cancelPayrollReceipt($receipt, $xml);
            }
        }
        return redirect('/payroll/assimilated/receipt/' . $id . '/edit');
    }

}
