<?php

namespace App\Http\Controllers\Assimilated;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Services\CFDIService;
use App\Model\Employee;
use App\Model\Partnership;
use App\Model\PayrollReceipt;
use App\Model\ReceiptEmployeeScatter;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class ReceiptController extends Controller
{

    /**
     * Shows a form for edit a payroll receipt
     * @param Request $request Request data
     * @param mixed $id payroll receipt id
     * @return Illuminate\View\View|Illuminate\Contracts\View\Factory 
     */
    public function edit(Request $request, $id) {
        $receipt = PayrollReceipt::find($id);
        $business = $receipt->payroll->businessClient;
        $partnerships = Partnership::all();

        $scatters = ReceiptEmployeeScatter::where('payroll_receipt_id', $receipt->id)
            ->with('employeeScatterWithRequest')
            ->get();
        
        return view('payroll.assimilated-receipt', [
            'payrollReceipt' => $receipt,
            'business' => $business,
            'partnerships' => $partnerships,
            'scatters' => $scatters
        ]);
    }

    /**
     * Save a payroll receipt
     * @param Request $request data information
     * @return Illuminate\Routing\Redirector|Illuminate\Http\RedirectResponse 
     */
    public function store(Request $request) {
        $receipt = PayrollReceipt::find($request->input('id'));
        $partnership = Partnership::where('code', $receipt->department)
            ->first();
        $employee = Employee::where('rfc', $receipt->rfc)
            ->where('partnership_id', $partnership->id)
            ->first();
        if ($employee) {
            if ($request->input('rfc') != $receipt->rfc) {
                if (Employee::where('rfc', $request->input('rfc'))
                    ->whereNotIn('id', [$employee->id])->count('id') > 0) {
                    Cache::put('warning', 'El RFC proporcionado pertenece a ' 
                        . 'otro empleado, favor de validar');
                    return redirect()->back()->withInput($request->input());
                }
                $employee->rfc = $request->input('rfc');
                $employee->save();
            }
            if ($request->input('curp') != $receipt->curp) {
                if (Employee::where('curp', $request->input('curp'))
                    ->whereNotIn('id', [$employee->id])->count() > 0) {
                    Cache::put('warning', 'El Curp proporcionado pertenece a ' 
                        . 'otro empleado, favor de validar');
                    return redirect()->back()->withInput($request->input());
                }
                $employee->curp = $request->input('curp');
                $employee->save();
            }
            if ($employee->name != $request->input('name')
                || $employee->last_name != $request->input('last-name')
                || $employee->last_name2 != $request->input('last-name2')) {
                $employee->name = $request->input('name');
                $employee->last_name = $request->input('last-name');
                $employee->last_name2 = $request->input('last-name2');
                $employee->save(); 
            }
        }
        $queryEmployee = Employee::where('employee_number', 
            $request->input('num-empleado'));
        if ($employee) {
            $queryEmployee->whereNotIn('id', [$employee->id]);
        }
        if ($queryEmployee->count() > 0) {
            Cache::put('warning', 'El número de empleado pertenece a ' 
                . 'otro empleado, favor de validar');
            return redirect()->back()->withInput($request->input());
        }
        $receipt->rfc = $request->input('rfc');
        $receipt->curp = $request->input('curp');
        $receipt->num_empleado = $request->input('num-empleado');
        $receipt->name = $request->input('name');
        $receipt->last_name = $request->input('last-name');
        $receipt->last_name2 = $request->input('last-name2');

        $receipt->total = round($request->input('total', 0), 2);
        $receipt->isr = CFDIService::getIsrForAssimilatedFromTotal(
            $receipt->total, $receipt->payroll->isr_period_id
        );
        $receipt->subtotal = round($receipt->total + $receipt->isr, 2);
        $receipt->save();

        Cache::put('message', 'Se salvo correctamente el recibo de nómina de ' . 
            $receipt->getFullName());
        return redirect('/payroll/assimilated/receipt/' . $receipt->id . '/edit');
    }
}
