<?php

namespace App\Http\Controllers\Assimilated;

use App\Http\Controllers\Controller;
use App\Model\Partnership;
use App\Model\Payroll;
use App\Model\PayrollReceipt;
use App\Model\ProcessRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;

class DownloadController extends Controller
{
    
    /**
     * Packages receipts on zip
     */
    public function packagePayroll(Request $request, $importCode) {
        $total = $this->getQueryFilter($request, $importCode)
                ->count('payroll_receipts.id');
        if ($total == 0) {
            Cache::put('warning', 'No hay recibos a descargar, 
                    por favor cambie los criterios de busqueda');
            return redirect()->back()->withInput($request->input());
        }
        $partnershipCode = $request->input('partnership', null);
        $status = $request->input('status', 'A');
        $filter = strtolower( trim($request['filter'] ));
        
        $payroll = Payroll::where('import_code', $importCode)->first();
        $partnership = Partnership::where('code', $partnershipCode)->first();
        $emails = '';
        foreach ($partnership->contacts as $contact) {
            if ($contact->email && strlen(ltrim($contact->email)) > 0) {
                if (strlen(ltrim($emails)) > 0) {
                    $emails .= ',';    
                }
                $emails .= $contact->email;
            }
        }

        $process = new ProcessRequest();
        $process->code = uniqid();
        $process->user_id = Auth::id();
        $process->command = ''; 
        $process->email = $emails;
        $process->description = '<strong>Cliente: </strong>' . $payroll->businessClient->name 
            . '<br><strong>Consorcio: </strong>' . $partnership->name;
        if ($status == 'D') {
            $process->description .= '<br><strong>Timbrado: </strong>vigentes';
        } else if ($status == 'M') {
            $process->description .= '<br><strong>Timbrado: </strong>no timbrados';
        } else if ($status == 'C') {
            $process->description .= '<br><strong>Timbrado: </strong>cancelados';
        }
        if (strlen($filter) > 0) {
            $process->description .= '<br><strong>Filtro: </strong>' . $filter;
        }
        $process->progress = 0;
        $process->start();
        $process->setExpireAt(5);
        $process->save();

        $process->command = 'bb:export-receipts ' . $process->id . ' --payroll=' . $importCode . ' --partnership-code=' . $partnershipCode;
        if ($status && $status != 'A') {
            $process->command .= ' --status=' . $status;   
        }
        $process->link_code = base64_encode($process->code . '|' . 
            $process->created_at . '|' . $payroll->businessClient->name);
        $process->save();

        $command = 'php /var/www/html/artisan ' . $process->command;
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $command = 'start php C:\Workspace\customers\BB\bb\artisan ' . $process->command . ' > NUL 2> NUL';
            $pid = popen($command, 'r');
            Log::info(pclose($pid));
        } else {
            shell_exec("/usr/bin/nohup ". $command." >/dev/null 2>&1 &");
        }
        return redirect('/downloads');
    }

    /**
     * Builds a query filter for payroll receipts
     */
    private function getQueryFilter(Request $request, $importCode) {
        $filter = strtolower( trim($request['filter'] ));
        $status = $request->input('status', 'A');
        $partnershipCode = $request->input('partnership', null);
        if (!$partnershipCode) {
            $partnershipCode = PayrollReceipt::
                join('payrolls', 'payrolls.id', '=', 'payroll_receipts.payroll_id')
                ->where('payrolls.import_code', $importCode)
                ->whereNull('payroll_receipts.removed_at')
                ->select('payroll_receipts.department')
                ->distinct()
                ->get()[0]->department;
        }
        $query = PayrollReceipt::
            join('payrolls', 'payrolls.id', '=', 'payroll_receipts.payroll_id')
            ->where('payrolls.import_code', $importCode)
            ->whereNull('payroll_receipts.removed_at');
        if (!$partnershipCode) {
            $partnershipCode = 'T';
        } else if ($partnershipCode != 'T') {
            $query->where('payroll_receipts.department', $partnershipCode);
        }
        if ($status == 'D') {
            $query->whereNotNull('payroll_receipts.uuid')
                ->whereNull('payroll_receipts.canceled_at');
        } else if ($status == 'M') {
            $query->whereNull('payroll_receipts.uuid');
        } else if ($status == 'C') {
            $query->whereNotNull('payroll_receipts.canceled_at');
        }
        if (strlen($filter) > 0) {
            $query->where(
                function($query) use ( $filter ) {
                    $query->where('payroll_receipts.rfc', 'like', 
                        '%' . $filter . '%')
                        ->orWhere(DB::raw('concat(payroll_receipts.name, " ", ' 
                            . 'payroll_receipts.last_name, " ", ' 
                            . 'payroll_receipts.last_name2)'), 
                        'like', '%' . $filter . '%');
                }
            );
        }
        return $query;
    }
}
