<?php

namespace App\Http\Controllers\AdminRequests;

use App\Http\Controllers\Controller;
use App\Http\Services\CatCFDIService;
use App\Model\PayrollWorkerReceipt;
use App\Model\WorkerReceiptReduction;
use Illuminate\Http\Request;

class WorkerReductionController extends Controller
{

    public function destroy(Request $request, $id) {
        $workerReceiptReduction = WorkerReceiptReduction::find($id);
        if ($workerReceiptReduction) {
            $receipt = PayrollWorkerReceipt::find($workerReceiptReduction->payroll_worker_receipt_id);
            $receipt->total += $workerReceiptReduction->amount;
            $receipt->save();

            $workerReceiptReduction->delete();
            return redirect("/requests/scatters/$receipt->id/receipt");
        }
        return redirect()->back()->withInput($request->input());
    }

    public static function saveCurrentDeduction(Request $request, PayrollWorkerReceipt $receipt) {
        $deductionAmount = $request->input('deduction-amount', 0);
        if (is_numeric($deductionAmount) && $deductionAmount > 0 && $receipt->total > $deductionAmount) {
            $deductionAmount = round($deductionAmount, 2);

            $deduction = new WorkerReceiptReduction();
            $deduction->payrollWorkerReceipt()->associate($receipt);
            $deduction->code = $request->input('deduction-code');
            $deduction->concept = $request->input('deduction-code');

            $types = CatCFDIService::getDeductionTypes();
            $concept = '';
            foreach ($types as $type) {
                if ($type['key'] == $deduction->concept) {
                    $concept = $type['value'];
                break;
                }
            }
            $deduction->concept = $concept;
            $deduction->amount = $deductionAmount;
            $deduction->save();

            $receipt->total -= $deductionAmount;
            $receipt->save();
        }
    }
}
