<?php

namespace App\Http\Controllers\AdminRequests;

use App\Http\Controllers\Controller;
use App\Http\Controllers\StampController as ControllersStampController;
use App\Http\Services\CertificaCFDI;
use App\Model\PayrollWorker;
use App\Model\PayrollWorkerReceipt;
use App\Model\ProcessRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Storage;

class StampController extends Controller
{
    /**
     * Stamps receipts of payroll
     */
    public function stampPayroll(Request $request, $id) {
        $payroll = PayrollWorker::find($id);
        $receipts = $payroll->payrollWorkerReceipts;

        if (count($receipts) > 0) {
            $process = new ProcessRequest();
            $process->code = uniqid();
            $process->user_id = Auth::id();
            $process->command = ''; 
            $process->description = '<strong>Cliente: </strong>' . 
                $payroll->request->businessClient->name;

            $process->progress = 0;
            $process->start();
            $process->setExpireAt(5);
            $process->save();

            $process->command = "bb:stamp-worker $process->id --payroll=$payroll->code";
            $process->save();

            $command = "php /var/www/html/artisan $process->command";
            if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
                $command = "start php C:\Workspace\customers\BB\bb\artisan $process->command > NUL 2> NUL";
                $pid = popen($command, 'r');
                Log::info(pclose($pid));
            } else {
                shell_exec("/usr/bin/nohup $command >/dev/null 2>&1 &");
            }
            return redirect('/sys-stampings');
        } else {
            Cache::put('warning', 'No existen recibos sin timbrar en esta importación');
            return redirect()->back()->withInput($request->input());
        }
    }

    /**
     * Cancel a payroll receipt
     * @param Request $request 
     * @return Illuminate\Routing\Redirector|Illuminate\Http\RedirectResponse 
     */
    public function cancel(Request $request, $id) {
        $receipt = PayrollWorkerReceipt::find($id);
        
        set_time_limit(300);
        if ($receipt->isStamped()) {
            $stamp = new ControllersStampController();
            $stamp->cancelPayrollReceipt($receipt);
            
            if (!$receipt->canceled_at) {
                $xml = Storage::disk('s3')->get($receipt->getStampPath() . $receipt->uuid . '.xml');
                CertificaCFDI::cancelPayrollReceipt($receipt, $xml);
            }
        }
        return redirect('/payroll/assimilated/receipt/' . $id . '/edit');
    }

}
