<?php

namespace App\Http\Controllers\AdminRequests;

use App\Http\Controllers\Controller;
use App\Model\Request as ModelRequest;
use App\Model\ScatterDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ScatterDetailController extends Controller
{
    
    public function approve(Request $request, $id) {
        $record = ScatterDetail::find($id);
        if (Auth::user()->type == 'BI') {
            $record->fac_status = 'A';
        } else if (Auth::user()->type == 'BA') {
            $record->bank_status = 'A';
        }
        $record->save();
        if ($record->fac_status && $record->fac_status == 'A' && $record->bank_status && $record->bank_status == 'A') {
            $record->employeeScatter->closePendingAmount();
        }
        return redirect("/requests/scatters/" . $record->employeeScatter->request_id . "/show");
    }

    public function approveAll(Request $request, $id) {
        $request = ModelRequest::find($id);

        $employees = $request->employeesWithFiles;
        foreach ($employees as $employee) {
            foreach ($employee->scatterDetails as $detail) {
                if ($detail->isSending()) {
                    if (Auth::user()->type == 'BI') {
                        $detail->fac_status = 'A';
                    } else if (Auth::user()->type == 'BA') {
                        $detail->bank_status = 'A';
                    }
                    $detail->save();
                    if ($detail->fac_status && $detail->fac_status == 'A' && $detail->bank_status && $detail->bank_status == 'A') {
                        $detail->employeeScatter->closePendingAmount();
                    }
                }
            }
        }
        return redirect("/requests/scatters/" . $id . "/show");
    }

}
