<?php

namespace App\Http\Controllers\AdminRequests;

use App\Http\Controllers\Controller;
use App\Model\EmployeeScatter;
use App\Model\EmployeeScatterFile;
use App\Model\Request as ModelRequest;
use App\Model\RequestFile;
use App\Model\ScatterDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use ZipArchive;

class RequestVoucherController extends Controller
{
    
    public function store(Request $request, $id) {
        $record = ModelRequest::find($id);
        $detailsIds = $request->input('employee-selected');
        if ($request->has('voucher-file') && count($detailsIds) > 0) {
            $file = $request->file('voucher-file');
            $deposit = new RequestFile();
            $deposit->type = 'receipt-pay';
            $deposit->request()->associate($record);
            $deposit->file = $record->businessClient->partnership->code . '/requests/' 
                . $record->id . '/deposits/' . $file->getClientOriginalName();
            $voucher = file_get_contents($file->getRealPath());
            Storage::disk('s3')->put($deposit->file, $voucher);
            $deposit->save();

            $scatterDetails = ScatterDetail::whereIn('id', $detailsIds)->get();
            foreach ($scatterDetails as $detail) {
                $detail->requestFile()->associate($deposit);
                $detail->save();
            }
        }
        return redirect("/requests/scatters/$record->id/show");
    }

    public function edit(Request $request, $id) {
        $record = RequestFile::find($id);

        $employeeScatterFiles = ScatterDetail::where('request_file_id', $id)->get();
        $employeeIds = $request->input('employee-selected-' . $id);

        for ($i = 0; $i < count($employeeIds); $i++) {
            $exist = false;
            foreach ($employeeScatterFiles as $scatterFile) {
                if ($scatterFile->id == $employeeIds[$i]) {
                    $exist = true;
                    break;
                }
            }
            if (!$exist) {

                $employeeFile = ScatterDetail::find($employeeIds[$i]);
                $employeeFile->requestFile()->associate($record);
                $employeeFile->save();
            }
        }
        $record->refresh();
        $employeeScatterFiles = ScatterDetail::where('request_file_id', $id)->get();
        foreach ($employeeScatterFiles as $scatterFile) {
            $exist = in_array($scatterFile->id, $employeeIds);
            if (!$exist) {
                $scatterFile->request_file_id = null;
                $scatterFile->save();
            }
        }            
        return redirect("/requests/scatters/$record->request_id/show");
    }

    public function destroy(Request $request, $id) {
        $record = RequestFile::find($id);
        Storage::disk('s3')->delete($record->file);

        $requestId = $record->request_id;

        $details = ScatterDetail::where('request_file_id', $id)->get();
        foreach ($details as $detail) {
            $detail->request_file_id = null;
            $detail->save();
        }
        $record->delete();
        return redirect("/requests/scatters/$requestId/show");
    }

    public function downloadEmployeeScatter(Request $request, $id) {
        set_time_limit(300);

        $employeeScatter = EmployeeScatter::find($id);
        if ($employeeScatter->hasEmployeeFiles()) {
            $employeeScatterFiles = $employeeScatter->scatterDetails;
            $files = [];
            foreach ($employeeScatterFiles as $employeeScatterFile) {
                if ($employeeScatterFile->requestFile) {
                    array_push($files, $employeeScatterFile->requestFile);
                }
            }
            $zipName = 'documentos.zip';
            if (Storage::disk('zips')->exists($zipName)) {
                Storage::disk('zips')->delete($zipName);
            }
            $storagePath  = Storage::disk('zips')->getDriver()->getAdapter()->getPathPrefix();
            $zipper = new ZipArchive();
            if ($zipper->open($storagePath . $zipName, ZipArchive::CREATE) === TRUE) {
                foreach ($files as $deposit) {
                    Storage::disk('zips')->put('documentos/' . $deposit->name_file, 
                        Storage::disk('s3')->get($deposit->file));
                    $zipper->addFile($storagePath . 'documentos/' . $deposit->name_file, $deposit->name_file);
                }

                $zipper->close();
                if (Storage::disk('zips')->exists('documentos')) {
                    Storage::disk('zips')->deleteDirectory('documentos');
                }
            }
            $storagePath  = Storage::disk('zips')->getDriver()->getAdapter()->getPathPrefix();
            if (Storage::disk('zips')->exists($zipName)) {
                return response()->download($storagePath . $zipName);
            }
        }

        return redirect()->back()->withInput($request->input());
    }

}
