<?php

namespace App\Http\Controllers\AdminRequests;

use App\Http\Controllers\Controller;
use App\Model\Partnership;
use App\Model\PayrollWorker;
use App\Model\ProcessRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;

class DownloadController extends Controller
{
    
    /**
     * Packages receipts on zip
     */
    public function packagePayroll(Request $request, $id) {
        /*
        $total = $this->getQueryFilter($request, $importCode)
                ->count('payroll_receipts.id');
        if ($total == 0) {
            Cache::put('warning', 'No hay recibos a descargar, 
                    por favor cambie los criterios de busqueda');
            return redirect()->back()->withInput($request->input());
        }*/

        $payroll = PayrollWorker::find($id);
        $emails = $payroll->request->user->email;

        $process = new ProcessRequest();
        $process->code = uniqid();
        $process->user_id = Auth::id();
        $process->command = ''; 
        $process->email = $emails;
        $process->description = '<strong>Cliente: </strong>' . $payroll->request->businessClient->name;
        $process->description .= '<br><strong>Timbrado: </strong>vigentes';

        $process->progress = 0;
        $process->start();
        $process->setExpireAt(5);
        $process->save();

        $process->command = 'bb:export-worker-receipts ' . $process->id . ' --payroll=' . $payroll->code;
        $process->link_code = base64_encode($process->code . '|' . 
            $process->created_at . '|' . $payroll->request->businessClient->name);
        $process->save();

        $command = "php /var/www/html/artisan $process->command";
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $command = "start php C:\Workspace\customers\BB\bb\artisan $process->command > NUL 2> NUL";
            $pid = popen($command, 'r');
            Log::info(pclose($pid));
        } else {
            shell_exec("/usr/bin/nohup $command >/dev/null 2>&1 &");
        }
        return redirect('/sys-downloads');
    }

}
