<?php

namespace App\Http\Controllers\AdminRequests;

use App\Http\Controllers\Controller;
use App\Http\Services\CatCFDIService;
use Illuminate\Http\Request;
use App\Http\Services\CodeService;
use App\Model\Bank;
use App\Model\Employee;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Cache;
use ZipArchive;

class CollaboratorController extends Controller
{
    
    public function command(Request $request, $id) {        
        if ($request->input('action') === 'reject-worker') {
            $emails = explode(',', $request->input('email'));
            $count = 0;
            foreach ($emails as $email) {
                $email = str_replace(" ", "", $email);
                if ($email != '' && strpos($email, '@') !== false) {
                    $count ++;    
                }
            }
            if ($count == 0) {
                Cache::put('warning', 'Por favor ingrese al menos un correo destinatario');
                return redirect()->back()->withInput($request->input());    
            }

            $record = Employee::find($id);
            $record->status = 'F';
            $record->save();
            
            if ($record->status == 'F') {
                $data = array(
                    'employee'=> $record->full_name,
                    'partnership' => Auth::user()->partnership(),
                    'answer' => $request->input('body')
                );
                Mail::send('emails.reject-employee', $data, function($message) use ($emails) {
                    $message->from('noreply@silifalcon.com', 
                        'BB DESPACHO INTEGRAL DE SERVICIOS SA DE CV');
                    $message->subject('Solicitud de alta de trabajador RECHAZADA');
                    foreach ($emails as $email) {
                        $email = str_replace(" ", "", $email);
                        if ($email != '' && strpos($email, '@') !== false) {
                            $message->to(str_replace(" ", "", $email));
                        }
                    }
                });
            }
            return redirect('/requests/workers');
        }
        return redirect()->back()->withInput($request->input());
    }
    
    public function edit(Request $request, $id) {
        $employee = Employee::find($id);

        $banks = Bank::all();
        return view('requests.employee-collaborator', [
            'record' => $employee,
            'banks' => $banks,
            'business' => $employee->business,
            'editable' => $employee->status == 'R',
            'adminFields' => 0,
            'federativeKeys' => CatCFDIService::getFederativeKeys(),
            'payrollTypes' => CatCFDIService::getPayrollTypes(),
            'contractTypes' => CatCFDIService::getContractTypes(),
            'regimeTypes' => CatCFDIService::getRegimeTypes(),
            'workstationRisks' => CatCFDIService::getWorkstationRisks(),
            'paymentPeriods' => CatCFDIService::getPaymentPeriod()
        ]);
    }

    /**
     * Retrieves a list of business
     * @param request Request data
     */
    public function index(Request $request) {
        $query = null;

        $page = $request->input('page-index', 0);
        $filter = $request->input('filter', null);

        $query = Employee::whereIn('status', ['P', 'F'])
            ->where('type', 'C')
            ->whereNull('canceled_at');
        
        $total = $query->count('id');
        
        $query->orderBy('id')
            ->offset($page * 25)
            ->limit(25);
        $totalPages = floor($total / 25) + ($total % 25 !== 0 ? 1 : 0);
        $pages = [ $page ];
        for ($i = $page - 1; $i >= 0 && $i >= $page - 2; $i--) {
            array_unshift($pages, $i);
        }
        for ($i = $page + 1; $i < $totalPages && count($pages) < 5; $i++) {
            array_push($pages, $i);
        }

        return view('requests.collaborator-index', [
            'data' => $query->get(),
            'total' => $total,
            'filter' => $filter,
            'page' => $page,
            'pages' => $pages
        ]);
    }

    /**
     * Downloads a zip package
     */
    public function approve(Request $request, $id) {
        $record = Employee::find($id);
        $record->status = 'R';
        if (!$record->employee_number) {
            $partnership = $record->partnership;
            $record->employee_number = CodeService::saveNext(
                '.' . $partnership->prefix, $partnership->code, 0
            );
        }
        $record->save();
        return redirect('/admin/employees/' . $record->id . '/edit');
    }

    /**
     * Downloads a zip package
     */
    public function reject(Request $request, $id) {
        $record = Employee::find($id);
        $record->status = 'F';
        $record->save();
        return redirect('/requests/collaborators');
    }

    /**
     * Downloads a zip package
     */
    public function download(Request $request, $id) {
        set_time_limit(300);
        
        $record = Employee::find($id);
        $zipName = 'documentos.zip';
        if (Storage::disk('zips')->exists($zipName)) {
            Storage::disk('zips')->delete($zipName);
        }
        $storagePath  = Storage::disk('zips')->getDriver()->getAdapter()->getPathPrefix();
        $zipper = new ZipArchive();

        if ($zipper->open($storagePath . $zipName, ZipArchive::CREATE) === TRUE) {
            if ($record->ine_file) {
                Storage::disk('zips')->put('documentos/' . $record->getIneFile(), 
                    Storage::disk('s3')->get($record->ine_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getIneFile(), 'ine_' . $record->getIneFile());
            }
            if ($record->address_file) {
                Storage::disk('zips')->put('documentos/' . $record->getAddressFile(), 
                    Storage::disk('s3')->get($record->address_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getAddressFile(), 'ine_' . $record->getAddressFile());
            }
            if ($record->rfc_file) {
                Storage::disk('zips')->put('documentos/' . $record->getRfcFile(), 
                    Storage::disk('s3')->get($record->rfc_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getRfcFile(), 'rfc_' . $record->getRfcFile());
            }
            if ($record->curp_file) {
                Storage::disk('zips')->put('documentos/' . $record->getCurpFile(), 
                    Storage::disk('s3')->get($record->curp_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getCurpFile(), 'curp_' . $record->getCurpFile());
            }
            if ($record->infonavit_file) {
                Storage::disk('zips')->put('documentos/' . $record->getInfonavitFile(), 
                    Storage::disk('s3')->get($record->infonavit_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getInfonavitFile(), 'inf_' . $record->getInfonavitFile());
            }
            if ($record->nss_file) {
                Storage::disk('zips')->put('documentos/' . $record->getNssFile(), 
                    Storage::disk('s3')->get($record->nss_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getNssFile(), 'nss_' . $record->getNssFile());
            }

            $zipper->close();
            if (Storage::disk('zips')->exists('documentos')) {
                Storage::disk('zips')->deleteDirectory('documentos');
            }
        }

        if ($record) {
            $storagePath  = Storage::disk('zips')->getDriver()->getAdapter()->getPathPrefix();
            if (Storage::disk('zips')->exists($zipName)) {
                return response()->download($storagePath . $zipName);
            }
        }
        return redirect()->back()->withInput($request->input());
    }

}
