<?php

namespace App\Http\Controllers\AdminRequests;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\Exports\ScatterExports;
use App\Model\BusinessClient;
use App\Model\EmployeeScatter;
use App\Model\Request as ModelRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use ZipArchive;

class BusinessController extends Controller
{
    
    /**
     * Retrieves a list of business
     * @param request Request data
     */
    public function index(Request $request) {
        $query = null;

        $page = $request->input('page-index', 0);
        $filter = $request->input('filter', null);

        $query = BusinessClient::where('type', 'E')
            ->where('status', 'P');
        
        $total = $query->count('id');
        
        $query->orderBy('id')
            ->offset($page * 25)
            ->limit(25);
        $totalPages = floor($total / 25) + ($total % 25 !== 0 ? 1 : 0);
        $pages = [ $page ];
        for ($i = $page - 1; $i >= 0 && $i >= $page - 2; $i--) {
            array_unshift($pages, $i);
        }
        for ($i = $page + 1; $i < $totalPages && count($pages) < 5; $i++) {
            array_push($pages, $i);
        }

        return view('requests.business-index', [
            'data' => $query->get(),
            'total' => $total,
            'filter' => $filter,
            'page' => $page,
            'pages' => $pages
        ]);
    }

    /**
     * Downloads a zip package
     */
    public function approve(Request $request, $id) {
        $record = BusinessClient::find($id);
        $record->status = 'R';
        $record->save();
        return redirect('/requests/business');
    }

    /**
     * Downloads a zip package
     */
    public function reject(Request $request, $id) {
        $record = BusinessClient::find($id);
        $record->status = 'F';
        $record->save();
        return redirect('/requests/business');
    }

    /**
     * Downloads a zip package
     */
    public function download(Request $request, $id) {
        set_time_limit(300);
        
        $record = BusinessClient::find($id);
        $zipName = 'documentos.zip';
        if (Storage::disk('zips')->exists($zipName)) {
            Storage::disk('zips')->delete($zipName);
        }
        $storagePath  = Storage::disk('zips')->getDriver()->getAdapter()->getPathPrefix();
        $zipper = new ZipArchive();

        if ($zipper->open($storagePath . $zipName, ZipArchive::CREATE) === TRUE) {
            if ($record->rfc_file) {
                Storage::disk('zips')->put('documentos/' . $record->getRFCFile(), 
                    Storage::disk('s3')->get($record->rfc_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getRFCFile(), 'rfc_' . $record->getRFCFile());
            }
            if ($record->address_file) {
                Storage::disk('zips')->put('documentos/' . $record->getAddressFile(), 
                    Storage::disk('s3')->get($record->address_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getAddressFile(), 'direccion_' . $record->getAddressFile());
            }
            if ($record->constitutive_act_file) {
                Storage::disk('zips')->put('documentos/' . $record->getConstitutiveActFile(), 
                    Storage::disk('s3')->get($record->constitutive_act_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getConstitutiveActFile(), 'acta_' . $record->getConstitutiveActFile());
            }
            if ($record->ife_file) {
                Storage::disk('zips')->put('documentos/' . $record->getIFEFile(), 
                    Storage::disk('s3')->get($record->ife_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getIFEFile(), 'ife_' . $record->getIFEFile());
            }
            if ($record->identification_card_file) {
                Storage::disk('zips')->put('documentos/' . $record->getIdentificationCardFile(), 
                    Storage::disk('s3')->get($record->identification_card_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getIdentificationCardFile(), 'ide_' . $record->getIdentificationCardFile());
            }
            if ($record->main_identification_card_file) {
                Storage::disk('zips')->put('documentos/' . $record->getMainIdentificationCardFile(), 
                    Storage::disk('s3')->get($record->main_identification_card_file));
                $zipper->addFile($storagePath . 'documentos/' . $record->getMainIdentificationCardFile(), 'rep_' . $record->getMainIdentificationCardFile());
            }

            $zipper->close();
            if (Storage::disk('zips')->exists('documentos')) {
                Storage::disk('zips')->deleteDirectory('documentos');
            }
        }

        if ($record) {
            $storagePath  = Storage::disk('zips')->getDriver()->getAdapter()->getPathPrefix();
            if (Storage::disk('zips')->exists($zipName)) {
                return response()->download($storagePath . $zipName);
            }
        }
        return redirect()->back()->withInput($request->input());
    }

    public function downloadScatter(Request $request, $id) {
        set_time_limit(300);
        
        $export = new ScatterExports();
        $export->query = EmployeeScatter::where('request_id', $id);
        return $export->download('dispercion.xlsx');
    }

}
