<?php

namespace App\Console\Commands;

use App\Http\Services\CertificaCFDI;
use App\Http\Services\CodeService;
use App\Http\Services\DocumentServices;
use App\Model\EmployeeScatter;
use Illuminate\Console\Command;
use App\Model\PayrollWorker;
use App\Model\PayrollWorkerReceipt;
use App\Model\ProcessRequest;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class StampWorkerCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bb:stamp-worker { process : process id }
                                { --payroll= : Import code }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Stamping worker payrolls';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle() {
        $this->info('Stamping workers');

        Log::info('Procesando comando');
        $processId = $this->argument('process');
        $payrollCode = $this->option('payroll');

        $payroll = PayrollWorker::where('code', $payrollCode)->first();

        Log::info('Proceso:' . $processId);
        Log::info('payroll:' . $payrollCode);

        $process = ProcessRequest::find($processId);
        $process->start();
        $process->save();

        $this->info('Processing: ' . $process->id);
        $this->info('Command: ' . $process->command);

        $query = PayrollWorkerReceipt::where('payroll_worker_id', $payroll->id)
            ->whereNull('uuid')
            ->whereNull('canceled_at');
            //->whereNull('payroll_receipts.removed_at');
        $receipts = $query->orderBy('id')->get();
        $countReceipts = count($receipts);
        $this->info('Found records ' . $countReceipts);
        if ($countReceipts > 0) {
            $code = '';
            for ($i = 0; $i < $countReceipts; $i++) {
                $receipt = $receipts[$i];
                if ($receipt->employee->type == 'W') {
                    Log::info("Timbrando recibo de nómina: $receipt->id <> $receipt->full_name");
                    $code = CodeService::getNext(
                        $receipt->employee->businessClient->getCodePattern($receipt->employee->getBusinessBranch()->id) . 'S',
                        $receipt->employee->businessClient->code
                    );
                    $xmlContent = DocumentServices::buildSysXMLContent($receipt, $code);
                    CertificaCFDI::stampPayrollWorkerReceipt($xmlContent, $receipt);
                    if ($receipt->isStamped()) {
                        $receipt->code = CodeService::saveNext(
                            $receipt->employee->businessClient->getCodePattern($receipt->employee->getBusinessBranch()->id) . 'S',
                            $receipt->employee->businessClient->code
                        );
                        $receipt->save();
                    }
                }

                $process->progress = $i * 100 / $countReceipts;
                $process->save();
            }
            EmployeeScatter::select('employee_scatters.*')
            ->join('requests', 'requests.id', '=', 'employee_scatters.request_id')
            ->join('payroll_worker_receipts', 'payroll_worker_receipts.employee_scatter_id', '=', 'employee_scatters.id')
            ->whereNotNull('payroll_worker_receipts.uuid')
            ->where('requests.id', $payroll->request_id)
            ->where('employee_scatters.sys', '=', 0)
            ->update(['employee_scatters.sys' => DB::raw('round(payroll_worker_receipts.total, 2)'),
                      'employee_scatters.as' => DB::raw('round(employee_scatters.amount - payroll_worker_receipts.total, 2)')]);
        }
        $process->finish();
        $process->save();
    }    
}
