<?php

namespace App\Console\Commands;

use App\Http\Controllers\StampController;
use App\Http\Services\CertificaCFDI;
use App\Http\Services\CodeService;
use App\Http\Services\DocumentServices;
use App\Model\Payroll;
use Illuminate\Console\Command;
use App\Model\PayrollReceipt;
use App\Model\ProcessRequest;
use App\Model\ReceiptEmployeeScatter;
use Illuminate\Support\Facades\Log;

class StampAssimilatedCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bb:stamp-assimilated { process : process id }
                                { --payroll= : Import code }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Stamping payrolls';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle() {
        $this->info('Stamping assimilateds');

        Log::info('Procesando comando');
        $processId = $this->argument('process');
        $exportCode = $this->option('payroll');

        Log::info('Proceso:' . $processId);
        Log::info('payroll:' . $exportCode);

        $process = ProcessRequest::find($processId);
        $process->start();
        $process->save();

        $this->info('Processing: ' . $process->id);
        $this->info('Command: ' . $process->command);

        $query = PayrollReceipt::
            join('payrolls', 'payrolls.id', '=', 'payroll_receipts.payroll_id');        
        if ($exportCode) {
            $query->where('payrolls.import_code', $exportCode);
        }
        $query->whereNull('payroll_receipts.uuid')
            ->whereNull('payroll_receipts.canceled_at')
            ->whereNull('payroll_receipts.removed_at');

        $query->select('payroll_receipts.*');
        $receipts = $query->get();
        $countReceipts = count($receipts);
        $this->info('Found records ' . $countReceipts);
        $stampReceipts = [];
        if ($countReceipts > 0) {
            $payroll = Payroll::where('import_code', $exportCode)
                ->get()->first();
            //$stamp = new StampController();
            $code = '';
            for ($i = 0; $i < $countReceipts; $i++) {
                $receipt = $receipts[$i];
                Log::info('Timbrando recibo de nómina: ' . $receipt->id);
                $code = CodeService::getNext(
                    $payroll->businessClient->getCodePattern($payroll->business_branch_id),
                    $payroll->businessClient->code
                );
                $xmlContent = DocumentServices::buildXMLContent($receipt, $code);

                //$stamp->stampPayrollReceipt($xmlContent, $receipt, $code);
                CertificaCFDI::stampPayrollReceipt($xmlContent, $receipt);
                if ($receipt->isStamped()) {
                    $receipt->code = CodeService::saveNext(
                        $payroll->businessClient->getCodePattern($payroll->business_branch_id),
                        $payroll->businessClient->code
                    );
                    $receipt->save();
                    array_push($stampReceipts, $receipt->id);
                }

                $process->progress = $i * 100 / $countReceipts;
                $process->save();
            }

            if (count($stampReceipts) > 0) {
                $scatters = ReceiptEmployeeScatter::whereIn('payroll_receipt_id', $stampReceipts)
                    ->with('employeeScatter')
                    ->get();
                foreach ($scatters as $scatter) {
                    $empScatter = $scatter->employeeScatter;
                    $empScatter->payed_as = $empScatter->as;
                    $empScatter->save();
                }
            }
        }

        $process->finish();
        $process->save();
    }    
}
