<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\DownloadController;
use App\Model\PayrollWorker;
use App\Model\PayrollWorkerReceipt;
use App\Model\ProcessRequest;
use Illuminate\Support\Facades\Log;
use ZipArchive;

class ExportWorkerReceiptsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bb:export-worker-receipts { process : process id }
                                { --payroll= : Import code }
                                { --send-email : Indicates if will send email }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Export a ZIP file into system';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle() {
        $this->info('start process');

        Log::info('Procesando comando');
        $processId = $this->argument('process');
        $exportCode = $this->option('payroll');
        $sendEmail = $this->option('send-email');

        $process = ProcessRequest::find($processId);
        $process->start();
        $process->save();

        $this->info('Processing: ' . $process->id);
        $this->info('Command: ' . $process->command);

        $payroll = PayrollWorker::where('code', $exportCode)->first();
        $receipts = PayrollWorkerReceipt::where('payroll_worker_id', $payroll->id)
            ->whereNotNull('uuid')
            ->get();
        $countReceipts = count($receipts);
        $this->info('Found records ' . $countReceipts);
        if ($countReceipts > 0) {
            $zipName = $process->code . '.zip';
            if (Storage::disk('zips')->exists($zipName)) {
                Storage::disk('zips')->delete($zipName);
            }
            $download = new DownloadController();
            $storagePath  = Storage::disk('zips')->getDriver()
                    ->getAdapter()->getPathPrefix();
            $zipper = new ZipArchive();
            if ($zipper->open($storagePath . $zipName, ZipArchive::CREATE) === TRUE) {
                for ($i = 1; $i <= $countReceipts; $i++) {
                    $r = $receipts[$i - 1];
                    if ($r->employee->type == 'W') {
                        $fileName = $process->code . '/' . $i . '.' . $r->full_name;
                        $data = $download->getContentSysPDF($r);
                        Storage::disk('zips')->put($fileName . '.pdf', $data);
                        $data = $download->getSysContentXML($r);
                        Storage::disk('zips')->put($fileName . '.xml', $data);

                        $process->progress = $i * 100 / $countReceipts;
                        $process->save();
                        $zipper->addFile($storagePath . $fileName . '.pdf', $i . '.' . $r->full_name . '.pdf');
                        $zipper->addFile($storagePath . $fileName . '.xml', $i . '.' . $r->full_name . '.xml');
                    }
                }
                $zipper->close();
                if (Storage::disk('zips')->exists($process->code . '')) {
                    Storage::disk('zips')->deleteDirectory($process->code . '');
                }
            }
        }
        $process->finish();
        if ($sendEmail) {
            $process->release();
        }
        $process->save();
    }

}
