<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Model\ProcessRequest;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class CleanExpiredPackagesCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bb:clean-packages';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean expired packages';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle() {
        Log::info(Carbon::now()->startOfDay()->format('Y-m-d H:m'));
        Log::info('Cleaning packages ' . 
            Carbon::now()->endOfDay()->format('Y-m-d H:m'));
        
        $query = ProcessRequest::where('status', 'D')
            ->whereNotNull('link_code')
            ->whereBetween('expired_at', 
                [Carbon::now()->startOfDay(), Carbon::now()->endOfDay()]);
        $processes = $query->get();
        $countProcesses = count($processes);
        $this->info('Found records ' . $countProcesses);
        if ($countProcesses > 0) {
            foreach ($processes as $process) {
                if (Storage::disk('zips')->exists($process->code . '.zip')) {
                    Log::info('Eliminando archivo' . $process->code . '.zip');
                    $this->info('Eliminando archivo' . $process->code . '.zip');
                    Storage::disk('zips')->delete($process->code . '.zip');
                } else {
                    Log::info('No se encontro el archivo' . $process->code . '.zip');
                }
            }
        }
    }    
}
